/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.ProfilerTooltipView;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.CpuThreadsTooltip;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class CpuThreadsTooltipView
extends ProfilerTooltipView {
    @NotNull
    private final CpuThreadsTooltip myTooltip;
    @NotNull
    private final ProfilerTimeline myTimeline;
    @VisibleForTesting
    @NotNull
    protected final JLabel myContent;

    protected CpuThreadsTooltipView(@NotNull CpuProfilerStageView view, @NotNull CpuThreadsTooltip tooltip) {
        if (view == null) {
            CpuThreadsTooltipView.$$$reportNull$$$0(0);
        }
        if (tooltip == null) {
            CpuThreadsTooltipView.$$$reportNull$$$0(1);
        }
        super(view.getTimeline(), "CPU");
        this.myTimeline = view.getTimeline();
        this.myTooltip = tooltip;
        this.myContent = new JLabel();
        this.myContent.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        this.myContent.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
        tooltip.addDependency(this).onChange((Enum)CpuThreadsTooltip.Aspect.THREAD_STATE, this::timeChanged);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myTooltip.removeDependencies(this);
    }

    @Override
    protected void timeChanged() {
        Range range = this.myTimeline.getTooltipRange();
        if (!range.isEmpty()) {
            String time = TimeAxisFormatter.DEFAULT.getFormattedString(this.myTimeline.getDataRange().getLength(), range.getMin() - this.myTimeline.getDataRange().getMin(), true);
            String title = this.myTooltip.getThreadName() != null ? this.myTooltip.getThreadName() : "CPU";
            this.myHeadingLabel.setText(String.format("<html>%s <span style='color:#%s'>%s</span></html", title, ColorUtil.toHex((Color)ProfilerColors.TOOLTIP_TIME_COLOR), time));
            this.myContent.setText(this.myTooltip.getThreadState() == null ? "" : CpuThreadsTooltipView.threadStateToString(this.myTooltip.getThreadState()));
            this.updateMaximumLabelDimensions();
        } else {
            this.myHeadingLabel.setText("");
            this.myContent.setText("");
        }
    }

    @Override
    @NotNull
    protected JComponent createTooltip() {
        JLabel jLabel = this.myContent;
        if (jLabel == null) {
            CpuThreadsTooltipView.$$$reportNull$$$0(2);
        }
        return jLabel;
    }

    private static String threadStateToString(@NotNull CpuProfilerStage.ThreadState state) {
        if (state == null) {
            CpuThreadsTooltipView.$$$reportNull$$$0(3);
        }
        switch (state) {
            case RUNNING: 
            case RUNNING_CAPTURED: {
                return "Running";
            }
            case SLEEPING: 
            case SLEEPING_CAPTURED: {
                return "Sleeping";
            }
            case DEAD: 
            case DEAD_CAPTURED: {
                return "Dead";
            }
            case WAITING: 
            case WAITING_CAPTURED: {
                return "Waiting";
            }
        }
        return "Unknown";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuThreadsTooltipView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuThreadsTooltipView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "threadStateToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

