/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class CpuUsageDataSeries
implements DataSeries<Long> {
    @NotNull
    private CpuServiceGrpc.CpuServiceBlockingStub myClient;
    private boolean myOtherProcesses;
    private final Common.Session mySession;

    public CpuUsageDataSeries(@NotNull CpuServiceGrpc.CpuServiceBlockingStub client, boolean otherProcesses, Common.Session session) {
        if (client == null) {
            CpuUsageDataSeries.$$$reportNull$$$0(0);
        }
        this.myClient = client;
        this.myOtherProcesses = otherProcesses;
        this.mySession = session;
    }

    public List<SeriesData<Long>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        if (timeCurrentRangeUs == null) {
            CpuUsageDataSeries.$$$reportNull$$$0(1);
        }
        ArrayList<SeriesData<Long>> seriesData = new ArrayList<SeriesData<Long>>();
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        CpuProfiler.CpuDataRequest.Builder dataRequestBuilder = CpuProfiler.CpuDataRequest.newBuilder().setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin()) - bufferNs).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()) + bufferNs);
        CpuProfiler.CpuDataResponse response = this.myClient.getData(dataRequestBuilder.build());
        CpuProfiler.CpuUsageData lastCpuData = null;
        for (CpuProfiler.CpuUsageData data : response.getDataList()) {
            long dataTimestamp = TimeUnit.NANOSECONDS.toMicros(data.getEndTimestamp());
            if (lastCpuData == null) {
                lastCpuData = data;
                continue;
            }
            UsageData usageData = CpuUsageDataSeries.getCpuUsageData(data, lastCpuData);
            if (this.myOtherProcesses) {
                seriesData.add((SeriesData<Long>)new SeriesData(dataTimestamp, (Object)((long)usageData.getOtherProcessesUsage())));
            } else {
                seriesData.add((SeriesData<Long>)new SeriesData(dataTimestamp, (Object)((long)usageData.getAppUsage())));
            }
            lastCpuData = data;
        }
        return seriesData;
    }

    private static UsageData getCpuUsageData(CpuProfiler.CpuUsageData data, CpuProfiler.CpuUsageData lastData) {
        long elapsed = data.getElapsedTimeInMillisec() - lastData.getElapsedTimeInMillisec();
        double app = 100.0 * (double)(data.getAppCpuTimeInMillisec() - lastData.getAppCpuTimeInMillisec()) / (double)elapsed;
        double system = 100.0 * (double)(data.getSystemCpuTimeInMillisec() - lastData.getSystemCpuTimeInMillisec()) / (double)elapsed;
        system = Math.max(0.0, Math.min(system, 100.0));
        app = Math.max(0.0, Math.min(app, system));
        return new UsageData(app, system);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/CpuUsageDataSeries";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataForXRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class UsageData {
        private double myAppUsage;
        private double mySystemUsage;

        UsageData(double appUsage, double systemUsage) {
            this.myAppUsage = appUsage;
            this.mySystemUsage = systemUsage;
        }

        double getAppUsage() {
            return this.myAppUsage;
        }

        double getOtherProcessesUsage() {
            return this.mySystemUsage - this.myAppUsage;
        }
    }
}

