/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.profiler.protobuf3jarjar.ByteString;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Queue;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.jetbrains.annotations.Nullable;
import trebuchet.io.BufferProducer;
import trebuchet.io.DataSlice;

public class AtraceDecompressor
implements BufferProducer {
    private static final int BUFFER_SIZE_BYTES = 2048;
    private byte[] myOutputBuffer = new byte[2048];
    private byte[] myInputBuffer = new byte[2048];
    private int myInputBufferOffset = 0;
    private boolean myIsFinished = false;
    private Queue<String> myLineQueue = new LinkedList<String>();
    private String myLastPartialLine = "";
    private InputStream myInputStream;
    private Inflater myInflater;
    private static final ByteString HEADER = ByteString.copyFrom((String)"TRACE:\n", (Charset)Charsets.UTF_8);

    public AtraceDecompressor(File file) throws IOException {
        this.myInputStream = new FileInputStream(file);
        this.myInflater = new Inflater();
        this.myInputStream.read(this.myInputBuffer, 0, HEADER.size());
        this.verifyHeader();
        this.myInputBufferOffset = 0;
        this.myLineQueue.add("# Initial Data Required by Importer");
    }

    private void verifyHeader() throws IOException {
        for (int i = 0; i < HEADER.size(); ++i) {
            assert (HEADER.byteAt(i) == this.myInputBuffer[this.myInputBufferOffset]);
            ++this.myInputBufferOffset;
        }
    }

    private void fill() throws IOException {
        if (this.myInputBufferOffset != 0) {
            this.shift(this.myInputBuffer, this.myInputBufferOffset, 0, this.myInputBuffer.length - this.myInputBufferOffset);
            this.myInputBufferOffset = this.myInputBuffer.length - this.myInputBufferOffset;
        }
        int readAmount = this.myInputStream.read(this.myInputBuffer, this.myInputBufferOffset, this.myInputBuffer.length - this.myInputBufferOffset);
        this.myInflater.setInput(this.myInputBuffer, 0, readAmount + this.myInputBufferOffset);
        this.myInputBufferOffset = 0;
    }

    private void shift(byte[] data, int srcOffset, int destOffset, int length) {
        for (int i = 0; i < length; ++i) {
            data[destOffset + i] = data[srcOffset + i];
        }
    }

    public String getNextLine() throws IOException, DataFormatException {
        if (this.myIsFinished && this.myLineQueue.isEmpty()) {
            return null;
        }
        while (this.myLineQueue.isEmpty()) {
            if (this.myInflater.finished()) {
                if (this.myInputStream.available() == 0) {
                    this.myIsFinished = true;
                    this.myInputStream.close();
                    this.myLineQueue.add(this.myLastPartialLine);
                    this.myLastPartialLine = "";
                    break;
                }
                this.verifyHeader();
                this.myInflater = new Inflater();
            }
            if (this.myInflater.needsInput()) {
                this.fill();
            }
            int inputBufferTotal = this.myInflater.getTotalIn();
            int bytesInOutputBuffer = this.myInflater.inflate(this.myOutputBuffer, 0, this.myOutputBuffer.length);
            inputBufferTotal = this.myInflater.getTotalIn() - inputBufferTotal;
            this.myInputBufferOffset += inputBufferTotal;
            this.myLastPartialLine = this.myLastPartialLine + new String(this.myOutputBuffer, 0, bytesInOutputBuffer);
            String[] lines = this.myLastPartialLine.split("\n", -1);
            for (int i = 0; i < lines.length - 1; ++i) {
                this.myLineQueue.add(lines[i]);
            }
            this.myLastPartialLine = this.myLastPartialLine.substring(this.myLastPartialLine.lastIndexOf(10) + 1);
        }
        return this.myLineQueue.remove();
    }

    public void close() {
        try {
            this.myInflater.end();
            this.myInputStream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Nullable
    public DataSlice next() {
        try {
            String line = this.getNextLine();
            if (line != null) {
                byte[] data = String.format("%s\n", line).getBytes();
                return new DataSlice(data, 0, data.length);
            }
        }
        catch (IOException | DataFormatException ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

