/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.event.EventModel;
import com.android.tools.adtui.model.event.SimpleEventType;
import com.android.tools.adtui.model.event.StackedEventType;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.ProfilerMonitorTooltip;
import com.android.tools.profilers.ProfilerTooltip;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.event.ActivityEventDataSeries;
import com.android.tools.profilers.event.EventActivityTooltip;
import com.android.tools.profilers.event.SimpleEventDataSeries;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class EventMonitor
extends ProfilerMonitor {
    @NotNull
    private final EventModel<SimpleEventType> mySimpleEvents;
    @NotNull
    private final EventModel<StackedEventType> myActivityEvents;
    @NotNull
    private final EventModel<StackedEventType> myFragmentEvents;
    private boolean myEnabled;
    private Supplier<ProfilerMonitorTooltip<EventMonitor>> myTooltipBuilder;

    public EventMonitor(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            EventMonitor.$$$reportNull$$$0(0);
        }
        super(profilers);
        SimpleEventDataSeries events = new SimpleEventDataSeries(this.myProfilers.getClient(), this.myProfilers.getSession());
        this.mySimpleEvents = new EventModel(new RangedSeries(this.getTimeline().getViewRange(), (DataSeries)events));
        ActivityEventDataSeries activities = new ActivityEventDataSeries(this.myProfilers.getClient(), this.myProfilers.getSession(), false);
        this.myActivityEvents = new EventModel(new RangedSeries(this.getTimeline().getViewRange(), (DataSeries)activities));
        ActivityEventDataSeries fragments = new ActivityEventDataSeries(this.myProfilers.getClient(), this.myProfilers.getSession(), true);
        this.myFragmentEvents = new EventModel(new RangedSeries(this.getTimeline().getViewRange(), (DataSeries)fragments));
        this.myProfilers.addDependency((AspectObserver)this).onChange((Enum)ProfilerAspect.AGENT, this::onAgentStatusChanged);
        this.onAgentStatusChanged();
    }

    @Override
    public void enter() {
        this.myProfilers.getUpdater().register(this.mySimpleEvents);
        this.myProfilers.getUpdater().register(this.myActivityEvents);
        this.myProfilers.getUpdater().register(this.myFragmentEvents);
    }

    @Override
    public void exit() {
        this.myProfilers.getUpdater().unregister(this.mySimpleEvents);
        this.myProfilers.getUpdater().unregister(this.myActivityEvents);
        this.myProfilers.getUpdater().unregister(this.myFragmentEvents);
    }

    @NotNull
    public EventModel<SimpleEventType> getSimpleEvents() {
        EventModel<SimpleEventType> eventModel = this.mySimpleEvents;
        if (eventModel == null) {
            EventMonitor.$$$reportNull$$$0(1);
        }
        return eventModel;
    }

    @NotNull
    public EventModel<StackedEventType> getActivityEvents() {
        EventModel<StackedEventType> eventModel = this.myActivityEvents;
        if (eventModel == null) {
            EventMonitor.$$$reportNull$$$0(2);
        }
        return eventModel;
    }

    @NotNull
    public EventModel<StackedEventType> getFragmentEvents() {
        EventModel<StackedEventType> eventModel = this.myFragmentEvents;
        if (eventModel == null) {
            EventMonitor.$$$reportNull$$$0(3);
        }
        return eventModel;
    }

    @Override
    public String getName() {
        return "EVENTS";
    }

    @Override
    public ProfilerTooltip buildTooltip() {
        if (this.myTooltipBuilder != null) {
            return this.myTooltipBuilder.get();
        }
        return new EventActivityTooltip(this);
    }

    public void setTooltipBuilder(Supplier<ProfilerMonitorTooltip<EventMonitor>> tooltip) {
        this.myTooltipBuilder = tooltip;
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    private void onAgentStatusChanged() {
        boolean agentAttached = this.myProfilers.isAgentAttached();
        if (this.myEnabled != agentAttached) {
            this.myEnabled = agentAttached;
            this.changed(ProfilerMonitor.Aspect.ENABLE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/event/EventMonitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/event/EventMonitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleEvents";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivityEvents";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragmentEvents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

