/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.EventIconRenderer;
import com.android.tools.adtui.KeyboardEventRenderer;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.SimpleEventComponent;
import com.android.tools.adtui.SimpleEventRenderer;
import com.android.tools.adtui.StackedEventComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TouchEventRenderer;
import com.android.tools.adtui.model.event.SimpleEventType;
import com.android.tools.profilers.ProfilerMonitorTooltip;
import com.android.tools.profilers.ProfilerMonitorView;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.event.EventActivityTooltip;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.event.EventSimpleEventTooltip;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class EventMonitorView
extends ProfilerMonitorView<EventMonitor> {
    private static final Map<SimpleEventType, SimpleEventRenderer<SimpleEventType>> RENDERERS = new HashMap<SimpleEventType, SimpleEventRenderer<SimpleEventType>>();
    private SimpleEventComponent<SimpleEventType> myEventComponent;
    private StackedEventComponent myActivityComponent;

    public EventMonitorView(@NotNull StudioProfilersView profilersView, @NotNull EventMonitor monitor) {
        if (profilersView == null) {
            EventMonitorView.$$$reportNull$$$0(0);
        }
        if (monitor == null) {
            EventMonitorView.$$$reportNull$$$0(1);
        }
        super(monitor);
        this.initializeComponents();
    }

    private void initializeComponents() {
        if (this.myActivityComponent == null) {
            this.myActivityComponent = new StackedEventComponent(((EventMonitor)((Object)this.getMonitor())).getActivityEvents());
        }
        if (this.myEventComponent == null) {
            this.myEventComponent = new SimpleEventComponent(((EventMonitor)((Object)this.getMonitor())).getSimpleEvents(), RENDERERS);
        }
    }

    @Override
    public float getVerticalWeight() {
        return 0.0f;
    }

    @Override
    public void registerTooltip(@NotNull RangeTooltipComponent tooltip, Stage stage) {
        if (tooltip == null) {
            EventMonitorView.$$$reportNull$$$0(2);
        }
        this.registerComponent((JComponent)this.myEventComponent, () -> new EventSimpleEventTooltip((EventMonitor)((Object)((Object)this.getMonitor()))), tooltip, stage);
        this.registerComponent((JComponent)this.myActivityComponent, () -> new EventActivityTooltip((EventMonitor)((Object)((Object)this.getMonitor()))), tooltip, stage);
    }

    private void registerComponent(JComponent component, final Supplier<ProfilerMonitorTooltip<EventMonitor>> tooltip, RangeTooltipComponent tooltipComponent, final Stage stage) {
        tooltipComponent.registerListenersOn((Component)component);
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (((EventMonitor)EventMonitorView.this.getMonitor()).isEnabled()) {
                    ((EventMonitor)EventMonitorView.this.getMonitor()).setTooltipBuilder(tooltip);
                    stage.setTooltip(((EventMonitor)EventMonitorView.this.getMonitor()).buildTooltip());
                } else {
                    stage.setTooltip(null);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                stage.setTooltip(null);
            }
        });
    }

    @Override
    protected void populateUi(JPanel container) {
        this.initializeComponents();
        container.setLayout((LayoutManager)new TabularLayout("*", "*,*"));
        container.add((Component)this.myEventComponent, new TabularLayout.Constraint(0, 0));
        container.add((Component)this.myActivityComponent, new TabularLayout.Constraint(1, 0));
    }

    static {
        RENDERERS.put(SimpleEventType.TOUCH, (SimpleEventRenderer<SimpleEventType>)new TouchEventRenderer());
        RENDERERS.put(SimpleEventType.ROTATION, (SimpleEventRenderer<SimpleEventType>)new EventIconRenderer("/icons/events/rotate-event.png"));
        RENDERERS.put(SimpleEventType.KEYBOARD, (SimpleEventRenderer<SimpleEventType>)new KeyboardEventRenderer());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilersView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "monitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/event/EventMonitorView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerTooltip";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

