/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.AllocStatsDataSeries;
import com.android.tools.profilers.memory.MemoryUsage;
import org.jetbrains.annotations.NotNull;

public class DetailedMemoryUsage
extends MemoryUsage {
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final Range myObjectsRange;
    @NotNull
    private final RangedContinuousSeries myJavaSeries;
    @NotNull
    private final RangedContinuousSeries myNativeSeries;
    @NotNull
    private final RangedContinuousSeries myGraphicsSeries;
    @NotNull
    private final RangedContinuousSeries myStackSeries;
    @NotNull
    private final RangedContinuousSeries myCodeSeries;
    @NotNull
    private final RangedContinuousSeries myOtherSeries;
    @NotNull
    private final RangedContinuousSeries myObjectsSeries;

    public DetailedMemoryUsage(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(0);
        }
        super(profilers);
        this.myProfilers = profilers;
        this.myObjectsRange = new Range(0.0, 0.0);
        this.myJavaSeries = this.createRangedSeries(profilers, "Java", this.getMemoryRange(), MemoryProfiler.MemoryData.MemorySample::getJavaMem);
        this.myNativeSeries = this.createRangedSeries(profilers, "Native", this.getMemoryRange(), MemoryProfiler.MemoryData.MemorySample::getNativeMem);
        this.myGraphicsSeries = this.createRangedSeries(profilers, "Graphics", this.getMemoryRange(), MemoryProfiler.MemoryData.MemorySample::getGraphicsMem);
        this.myStackSeries = this.createRangedSeries(profilers, "Stack", this.getMemoryRange(), MemoryProfiler.MemoryData.MemorySample::getStackMem);
        this.myCodeSeries = this.createRangedSeries(profilers, "Code", this.getMemoryRange(), MemoryProfiler.MemoryData.MemorySample::getCodeMem);
        this.myOtherSeries = this.createRangedSeries(profilers, "Others", this.getMemoryRange(), MemoryProfiler.MemoryData.MemorySample::getOthersMem);
        MemoryServiceGrpc.MemoryServiceBlockingStub client = profilers.getClient().getMemoryClient();
        AllocStatsDataSeries series = new AllocStatsDataSeries(client, profilers.getSession(), sample -> sample.getJavaAllocationCount() - sample.getJavaFreeCount());
        this.myObjectsSeries = new RangedContinuousSeries("Allocated", profilers.getTimeline().getViewRange(), this.getObjectsRange(), (DataSeries)series);
        this.add(this.myJavaSeries);
        this.add(this.myNativeSeries);
        this.add(this.myGraphicsSeries);
        this.add(this.myStackSeries);
        this.add(this.myCodeSeries);
        this.add(this.myOtherSeries);
        this.myProfilers.addDependency((AspectObserver)this).onChange((Enum)ProfilerAspect.AGENT, this::agentStatusChanged);
        this.agentStatusChanged();
    }

    @NotNull
    public Range getObjectsRange() {
        Range range = this.myObjectsRange;
        if (range == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(1);
        }
        return range;
    }

    @NotNull
    public RangedContinuousSeries getJavaSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myJavaSeries;
        if (rangedContinuousSeries == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(2);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public RangedContinuousSeries getNativeSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myNativeSeries;
        if (rangedContinuousSeries == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(3);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public RangedContinuousSeries getGraphicsSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myGraphicsSeries;
        if (rangedContinuousSeries == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(4);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public RangedContinuousSeries getStackSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myStackSeries;
        if (rangedContinuousSeries == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(5);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public RangedContinuousSeries getCodeSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myCodeSeries;
        if (rangedContinuousSeries == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(6);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public RangedContinuousSeries getOtherSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myOtherSeries;
        if (rangedContinuousSeries == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(7);
        }
        return rangedContinuousSeries;
    }

    @NotNull
    public RangedContinuousSeries getObjectsSeries() {
        RangedContinuousSeries rangedContinuousSeries = this.myObjectsSeries;
        if (rangedContinuousSeries == null) {
            DetailedMemoryUsage.$$$reportNull$$$0(8);
        }
        return rangedContinuousSeries;
    }

    @Override
    protected String getTotalSeriesLabel() {
        return "Total";
    }

    private void agentStatusChanged() {
        if (this.myProfilers.isAgentAttached()) {
            this.add(this.myObjectsSeries);
        } else {
            this.remove(this.myObjectsSeries);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/DetailedMemoryUsage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/DetailedMemoryUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsRange";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaSeries";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeSeries";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphicsSeries";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackSeries";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeSeries";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOtherSeries";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsSeries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

