/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.AxisComponentModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.MemoryAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.ProfilerTooltip;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.MemoryMonitorTooltip;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryUsage;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

public class MemoryMonitor
extends ProfilerMonitor {
    @NotNull
    private final AxisComponentModel myMemoryAxis;
    private static final BaseAxisFormatter MEMORY_AXIS_FORMATTER = new MemoryAxisFormatter(1, 2, 5);
    private final MemoryUsage myMemoryUsage;
    private final MemoryLegend myMemoryLegend;
    private MemoryLegend myTooltipLegend;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryMonitor.class);
    }

    public MemoryMonitor(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            MemoryMonitor.$$$reportNull$$$0(0);
        }
        super(profilers);
        this.myMemoryUsage = new MemoryUsage(profilers);
        this.myMemoryAxis = new AxisComponentModel(this.myMemoryUsage.getMemoryRange(), MEMORY_AXIS_FORMATTER);
        this.myMemoryAxis.setClampToMajorTicks(true);
        this.myMemoryLegend = new MemoryLegend(this.myMemoryUsage, this.getTimeline().getDataRange(), 100);
        this.myTooltipLegend = new MemoryLegend(this.myMemoryUsage, this.getTimeline().getTooltipRange(), 0);
    }

    @Override
    public String getName() {
        return "MEMORY";
    }

    @Override
    public ProfilerTooltip buildTooltip() {
        return new MemoryMonitorTooltip(this);
    }

    @Override
    public void enter() {
        this.myProfilers.getUpdater().register((Updatable)this.myMemoryUsage);
        this.myProfilers.getUpdater().register((Updatable)this.myMemoryAxis);
        this.myProfilers.getUpdater().register((Updatable)this.myMemoryLegend);
        this.myProfilers.getUpdater().register((Updatable)this.myTooltipLegend);
    }

    @Override
    public void exit() {
        this.myProfilers.getUpdater().unregister((Updatable)this.myMemoryUsage);
        this.myProfilers.getUpdater().unregister((Updatable)this.myMemoryAxis);
        this.myProfilers.getUpdater().unregister((Updatable)this.myMemoryLegend);
        this.myProfilers.getUpdater().unregister((Updatable)this.myTooltipLegend);
        this.myProfilers.removeDependencies((AspectObserver)this);
    }

    @Override
    public void expand() {
        this.myProfilers.setStage(new MemoryProfilerStage(this.myProfilers));
    }

    @NotNull
    public AxisComponentModel getMemoryAxis() {
        AxisComponentModel axisComponentModel = this.myMemoryAxis;
        if (axisComponentModel == null) {
            MemoryMonitor.$$$reportNull$$$0(1);
        }
        return axisComponentModel;
    }

    public MemoryUsage getMemoryUsage() {
        return this.myMemoryUsage;
    }

    public MemoryLegend getMemoryLegend() {
        return this.myMemoryLegend;
    }

    public MemoryLegend getTooltipLegend() {
        return this.myTooltipLegend;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryMonitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryMonitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemoryAxis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MemoryLegend
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myTotalLegend;

        public MemoryLegend(@NotNull MemoryUsage usage, @NotNull Range range, int updateFrequencyMs) {
            if (usage == null) {
                MemoryLegend.$$$reportNull$$$0(0);
            }
            if (range == null) {
                MemoryLegend.$$$reportNull$$$0(1);
            }
            super(updateFrequencyMs);
            this.myTotalLegend = new SeriesLegend(usage.getTotalMemorySeries(), MEMORY_AXIS_FORMATTER, range);
            this.add((Legend)this.myTotalLegend);
        }

        @NotNull
        public Legend getTotalLegend() {
            SeriesLegend seriesLegend = this.myTotalLegend;
            if (seriesLegend == null) {
                MemoryLegend.$$$reportNull$$$0(2);
            }
            return seriesLegend;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/memory/MemoryMonitor$MemoryLegend";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/memory/MemoryMonitor$MemoryLegend";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTotalLegend";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

