/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.MethodSet;
import com.android.tools.profilers.stacktrace.ThreadId;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadSet
extends ClassifierSet {
    @NotNull
    private final CaptureObject myCaptureObject;
    @NotNull
    private final ThreadId myThreadId;

    @NotNull
    public static ClassifierSet.Classifier createDefaultClassifier(@NotNull CaptureObject captureObject) {
        if (captureObject == null) {
            ThreadSet.$$$reportNull$$$0(0);
        }
        ThreadClassifier threadClassifier = new ThreadClassifier(captureObject);
        if (threadClassifier == null) {
            ThreadSet.$$$reportNull$$$0(1);
        }
        return threadClassifier;
    }

    public ThreadSet(@NotNull CaptureObject captureObject, @NotNull ThreadId threadId) {
        if (captureObject == null) {
            ThreadSet.$$$reportNull$$$0(2);
        }
        if (threadId == null) {
            ThreadSet.$$$reportNull$$$0(3);
        }
        super(threadId.toString());
        this.myCaptureObject = captureObject;
        this.myThreadId = threadId;
    }

    @NotNull
    public ThreadId getThreadId() {
        ThreadId threadId = this.myThreadId;
        if (threadId == null) {
            ThreadSet.$$$reportNull$$$0(4);
        }
        return threadId;
    }

    @Override
    @NotNull
    public ClassifierSet.Classifier createSubClassifier() {
        ClassifierSet.Classifier classifier = MethodSet.createDefaultClassifier(this.myCaptureObject);
        if (classifier == null) {
            ThreadSet.$$$reportNull$$$0(5);
        }
        return classifier;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureObject";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/ThreadSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/ThreadSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultClassifier";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubClassifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultClassifier";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ThreadClassifier
    extends ClassifierSet.Classifier {
        @NotNull
        private final CaptureObject myCaptureObject;
        @NotNull
        private final Map<ThreadId, ThreadSet> myThreadSets;
        @NotNull
        private final ClassifierSet.Classifier myMethodSetClassifier;

        private ThreadClassifier(@NotNull CaptureObject captureObject) {
            if (captureObject == null) {
                ThreadClassifier.$$$reportNull$$$0(0);
            }
            this.myThreadSets = new LinkedHashMap<ThreadId, ThreadSet>();
            this.myCaptureObject = captureObject;
            this.myMethodSetClassifier = MethodSet.createDefaultClassifier(this.myCaptureObject);
        }

        @Override
        @Nullable
        public ClassifierSet getClassifierSet(@NotNull InstanceObject instance, boolean createIfAbsent) {
            if (instance == null) {
                ThreadClassifier.$$$reportNull$$$0(1);
            }
            if (instance.getAllocationThreadId() != ThreadId.INVALID_THREAD_ID) {
                ThreadId threadId = instance.getAllocationThreadId();
                ThreadSet threadSet = this.myThreadSets.get(threadId);
                if (threadSet == null && createIfAbsent) {
                    threadSet = new ThreadSet(this.myCaptureObject, threadId);
                    this.myThreadSets.put(threadId, threadSet);
                }
                return threadSet;
            }
            return this.myMethodSetClassifier.getClassifierSet(instance, createIfAbsent);
        }

        @Override
        @NotNull
        public List<ClassifierSet> getFilteredClassifierSets() {
            List<ClassifierSet> list = Stream.concat(this.myThreadSets.values().stream(), this.myMethodSetClassifier.getFilteredClassifierSets().stream()).filter(child -> !child.getIsFiltered()).collect(Collectors.toList());
            if (list == null) {
                ThreadClassifier.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        @NotNull
        protected List<ClassifierSet> getAllClassifierSets() {
            List<ClassifierSet> list = Stream.concat(this.myThreadSets.values().stream(), this.myMethodSetClassifier.getAllClassifierSets().stream()).collect(Collectors.toList());
            if (list == null) {
                ThreadClassifier.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "captureObject";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instance";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/memory/adapters/ThreadSet$ThreadClassifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/memory/adapters/ThreadSet$ThreadClassifier";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilteredClassifierSets";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllClassifierSets";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getClassifierSet";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

