/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.AxisComponentModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayeredPane;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.network.BorderlessTableCellRenderer;
import com.android.tools.profilers.network.ConnectionsStateChart;
import com.android.tools.profilers.network.HoverRowTable;
import com.android.tools.profilers.network.HttpDataFetcher;
import com.android.tools.profilers.network.NetworkProfilerAspect;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.network.NetworkProfilerStageView;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

final class ConnectionsView {
    @NotNull
    private final NetworkProfilerStage myStage;
    @NotNull
    private final ConnectionsTableModel myTableModel;
    @NotNull
    private final HoverRowTable myConnectionsTable;
    @NotNull
    private final AspectObserver myAspectObserver;

    ConnectionsView(@NotNull NetworkProfilerStageView stageView) {
        if (stageView == null) {
            ConnectionsView.$$$reportNull$$$0(0);
        }
        this.myStage = (NetworkProfilerStage)stageView.getStage();
        this.myTableModel = new ConnectionsTableModel(this.myStage.getHttpDataFetcher());
        this.myConnectionsTable = new HoverRowTable(this.myTableModel, ProfilerColors.DEFAULT_HOVER_COLOR);
        this.customizeConnectionsTable();
        this.createTooltip();
        this.myAspectObserver = new AspectObserver();
        this.myStage.getAspect().addDependency(this.myAspectObserver).onChange((Enum)NetworkProfilerAspect.SELECTED_CONNECTION, this::updateTableSelection);
    }

    @NotNull
    public JComponent getComponent() {
        HoverRowTable hoverRowTable = this.myConnectionsTable;
        if (hoverRowTable == null) {
            ConnectionsView.$$$reportNull$$$0(1);
        }
        return hoverRowTable;
    }

    private void customizeConnectionsTable() {
        this.myConnectionsTable.setAutoCreateRowSorter(true);
        this.myConnectionsTable.getColumnModel().getColumn(Column.NAME.ordinal()).setCellRenderer(new BorderlessTableCellRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.SIZE.ordinal()).setCellRenderer(new SizeRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.TYPE.ordinal()).setCellRenderer(new BorderlessTableCellRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.STATUS.ordinal()).setCellRenderer(new StatusRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.TIME.ordinal()).setCellRenderer(new TimeRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.TIMELINE.ordinal()).setCellRenderer(new TimelineRenderer((JTable)((Object)this.myConnectionsTable), this.myStage.getStudioProfilers().getTimeline().getSelectionRange()));
        this.myConnectionsTable.setTableHeaderBorder(ProfilerLayout.TABLE_COLUMN_HEADER_BORDER);
        this.myConnectionsTable.setSelectionMode(0);
        this.myConnectionsTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int selectedRow = this.myConnectionsTable.getSelectedRow();
            if (0 <= selectedRow && selectedRow < this.myTableModel.getRowCount()) {
                int modelRow = this.myConnectionsTable.convertRowIndexToModel(selectedRow);
                this.myStage.setSelectedConnection(this.myTableModel.getHttpData(modelRow));
            }
        });
        this.myConnectionsTable.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.myConnectionsTable.setShowVerticalLines(true);
        this.myConnectionsTable.setShowHorizontalLines(false);
        int defaultFontHeight = this.myConnectionsTable.getFontMetrics(this.myConnectionsTable.getFont()).getHeight();
        this.myConnectionsTable.setRowMargin(0);
        this.myConnectionsTable.setRowHeight(defaultFontHeight + ProfilerLayout.ROW_HEIGHT_PADDING);
        this.myConnectionsTable.setFocusTraversalKeys(0, null);
        this.myConnectionsTable.setFocusTraversalKeys(1, null);
        this.myConnectionsTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                for (int i = 0; i < Column.values().length; ++i) {
                    Column column = Column.values()[i];
                    ConnectionsView.this.myConnectionsTable.getColumnModel().getColumn(i).setPreferredWidth((int)((double)ConnectionsView.this.myConnectionsTable.getWidth() * column.getWidthPercentage()));
                }
            }
        });
        this.myStage.getHttpDataFetcher().addListener(httpDataList -> this.updateTableSelection());
    }

    private void createTooltip() {
        final JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setBorder(ProfilerLayout.TOOLTIP_BORDER);
        textPane.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        textPane.setForeground(ProfilerColors.MONITORS_HEADER_TEXT);
        textPane.setFont(this.myConnectionsTable.getFont().deriveFont(11.0f));
        final TooltipComponent tooltip = new TooltipComponent((Component)textPane, (Component)((Object)this.myConnectionsTable), ProfilerLayeredPane.class);
        tooltip.registerListenersOn((Component)((Object)this.myConnectionsTable));
        this.myConnectionsTable.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = ConnectionsView.this.myConnectionsTable.rowAtPoint(e.getPoint());
                if (row >= 0) {
                    tooltip.setVisible(true);
                    String url = ConnectionsView.this.myTableModel.getHttpData(ConnectionsView.this.myConnectionsTable.convertRowIndexToModel(row)).getUrl();
                    textPane.setText(url);
                } else {
                    tooltip.setVisible(false);
                }
            }
        });
    }

    private void updateTableSelection() {
        HttpData selectedData = this.myStage.getSelectedConnection();
        if (selectedData != null) {
            for (int i = 0; i < this.myTableModel.getRowCount(); ++i) {
                if (this.myTableModel.getHttpData(i).getId() != selectedData.getId()) continue;
                int row = this.myConnectionsTable.convertRowIndexToView(i);
                this.myConnectionsTable.setRowSelectionInterval(row, row);
                return;
            }
        } else {
            this.myConnectionsTable.clearSelection();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stageView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/ConnectionsView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/ConnectionsView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class TimelineRenderer
    implements TableCellRenderer,
    TableModelListener {
        @NotNull
        private final List<ConnectionsStateChart> myConnectionsCharts;
        @NotNull
        private final JTable myTable;
        @NotNull
        private final Range myRange;

        TimelineRenderer(@NotNull JTable table, Range range) {
            if (table == null) {
                TimelineRenderer.$$$reportNull$$$0(0);
            }
            if (range == null) {
                TimelineRenderer.$$$reportNull$$$0(1);
            }
            this.myConnectionsCharts = new ArrayList<ConnectionsStateChart>();
            this.myTable = table;
            this.myRange = range;
            this.myTable.getModel().addTableModelListener(this);
            this.tableChanged(new TableModelEvent(this.myTable.getModel()));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ConnectionsStateChart chart = this.myConnectionsCharts.get(this.myTable.convertRowIndexToModel(row));
            chart.getColors().setColorIndex(isSelected ? 1 : 0);
            JBPanel panel = new JBPanel((LayoutManager)new TabularLayout("*", "*"));
            if (row == 0) {
                AxisComponent axisLabels = this.createAxis();
                axisLabels.setMarkerLengths(0, 0);
                panel.add((Component)axisLabels, new TabularLayout.Constraint(0, 0));
            }
            panel.add((Component)chart.getComponent(), new TabularLayout.Constraint(0, 0));
            AxisComponent axisTicks = this.createAxis();
            axisTicks.setMarkerLengths(this.myTable.getRowHeight(), 0);
            axisTicks.setShowLabels(false);
            panel.add((Component)axisTicks, new TabularLayout.Constraint(0, 0));
            return panel;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.myConnectionsCharts.clear();
            ConnectionsTableModel model = (ConnectionsTableModel)this.myTable.getModel();
            for (int i = 0; i < model.getRowCount(); ++i) {
                ConnectionsStateChart chart = new ConnectionsStateChart(model.getHttpData(i), this.myRange);
                chart.setHeightGap(0.3f);
                this.myConnectionsCharts.add(chart);
            }
        }

        @NotNull
        private AxisComponent createAxis() {
            AxisComponentModel model = new AxisComponentModel(this.myRange, (BaseAxisFormatter)new TimeAxisFormatter(1, 4, 1));
            model.setClampToMajorTicks(false);
            model.setGlobalRange(ConnectionsView.this.myStage.getStudioProfilers().getTimeline().getDataRange());
            AxisComponent axis = new AxisComponent(model, AxisComponent.AxisOrientation.BOTTOM);
            axis.setShowAxisLine(false);
            axis.setMarkerColor(ProfilerColors.NETWORK_TABLE_AXIS);
            model.update(1L);
            AxisComponent axisComponent = axis;
            if (axisComponent == null) {
                TimelineRenderer.$$$reportNull$$$0(2);
            }
            return axisComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/network/ConnectionsView$TimelineRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/network/ConnectionsView$TimelineRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAxis";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class TimeRenderer
    extends BorderlessTableCellRenderer {
        private TimeRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            Long durationUs = (Long)value;
            if (durationUs >= 0L) {
                long durationMs = TimeUnit.MICROSECONDS.toMillis(durationUs);
                this.setText(StringUtil.formatDuration((long)durationMs));
            } else {
                this.setText("");
            }
        }
    }

    private static final class StatusRenderer
    extends BorderlessTableCellRenderer {
        private StatusRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            Integer status = (Integer)value;
            this.setText(status > -1 ? Integer.toString(status) : "");
        }
    }

    private static final class SizeRenderer
    extends BorderlessTableCellRenderer {
        private SizeRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            int bytes = (Integer)value;
            this.setText(bytes >= 0 ? StringUtil.formatFileSize((long)bytes) : "");
        }
    }

    private final class ConnectionsTableModel
    extends AbstractTableModel {
        @NotNull
        private List<HttpData> myDataList = new ArrayList<HttpData>();

        private ConnectionsTableModel(HttpDataFetcher httpDataFetcher) {
            httpDataFetcher.addListener(httpDataList -> {
                this.myDataList = httpDataList;
                this.fireTableDataChanged();
            });
        }

        @Override
        public int getRowCount() {
            return this.myDataList.size();
        }

        @Override
        public int getColumnCount() {
            return Column.values().length;
        }

        @Override
        public String getColumnName(int column) {
            return Column.values()[column].toDisplayString();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            HttpData data = this.myDataList.get(rowIndex);
            return Column.values()[columnIndex].getValueFrom(data);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Column.values()[columnIndex].getType();
        }

        @NotNull
        public HttpData getHttpData(int rowIndex) {
            HttpData httpData = this.myDataList.get(rowIndex);
            if (httpData == null) {
                ConnectionsTableModel.$$$reportNull$$$0(0);
            }
            return httpData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/profilers/network/ConnectionsView$ConnectionsTableModel", "getHttpData"));
        }
    }

    @VisibleForTesting
    static enum Column {
        NAME(0.25, (Class)String.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                if (data == null) {
                    1.$$$reportNull$$$0(0);
                }
                return HttpData.getUrlName(data.getUrl());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/profilers/network/ConnectionsView$Column$1", "getValueFrom"));
            }
        }
        ,
        SIZE(0.0625, (Class)Integer.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                if (data == null) {
                    2.$$$reportNull$$$0(0);
                }
                return data.getResponsePayloadSize();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/profilers/network/ConnectionsView$Column$2", "getValueFrom"));
            }
        }
        ,
        TYPE(0.0625, (Class)String.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                if (data == null) {
                    3.$$$reportNull$$$0(0);
                }
                HttpData.ContentType type = data.getResponseHeader().getContentType();
                return type.getMimeType();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/profilers/network/ConnectionsView$Column$3", "getValueFrom"));
            }
        }
        ,
        STATUS(0.0625, (Class)Integer.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                if (data == null) {
                    4.$$$reportNull$$$0(0);
                }
                return data.getResponseHeader().getStatusCode();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/profilers/network/ConnectionsView$Column$4", "getValueFrom"));
            }
        }
        ,
        TIME(0.0625, (Class)Long.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                if (data == null) {
                    5.$$$reportNull$$$0(0);
                }
                return data.getEndTimeUs() - data.getStartTimeUs();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/profilers/network/ConnectionsView$Column$5", "getValueFrom"));
            }
        }
        ,
        TIMELINE(0.5, (Class)Long.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                if (data == null) {
                    6.$$$reportNull$$$0(0);
                }
                return data.getStartTimeUs();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/profilers/network/ConnectionsView$Column$6", "getValueFrom"));
            }
        };

        private final double myWidthPercentage;
        private final Class<?> myType;

        private Column(double widthPercentage, Class<?> type) {
            this.myWidthPercentage = widthPercentage;
            this.myType = type;
        }

        public double getWidthPercentage() {
            return this.myWidthPercentage;
        }

        public Class<?> getType() {
            return this.myType;
        }

        public String toDisplayString() {
            return StringUtil.capitalize((String)this.name().toLowerCase(Locale.getDefault()));
        }

        abstract Object getValueFrom(@NotNull HttpData var1);
    }
}

