/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class NetworkRadioDataSeries
implements DataSeries<RadioState> {
    @NotNull
    private final NetworkServiceGrpc.NetworkServiceBlockingStub myClient;
    @NotNull
    private final Common.Session mySession;

    public NetworkRadioDataSeries(@NotNull NetworkServiceGrpc.NetworkServiceBlockingStub client, @NotNull Common.Session session) {
        if (client == null) {
            NetworkRadioDataSeries.$$$reportNull$$$0(0);
        }
        if (session == null) {
            NetworkRadioDataSeries.$$$reportNull$$$0(1);
        }
        this.myClient = client;
        this.mySession = session;
    }

    @NotNull
    public List<SeriesData<RadioState>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        if (timeCurrentRangeUs == null) {
            NetworkRadioDataSeries.$$$reportNull$$$0(2);
        }
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        NetworkProfiler.NetworkDataRequest.Builder dataRequestBuilder = NetworkProfiler.NetworkDataRequest.newBuilder().setSession(this.mySession).setType(NetworkProfiler.NetworkDataRequest.Type.CONNECTIVITY).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin()) - bufferNs).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()) + bufferNs);
        NetworkProfiler.NetworkDataResponse response = this.myClient.getData(dataRequestBuilder.build());
        ArrayList<SeriesData<RadioState>> seriesData = new ArrayList<SeriesData<RadioState>>();
        block8: for (NetworkProfiler.NetworkProfilerData data : response.getDataList()) {
            long timestampUs = TimeUnit.NANOSECONDS.toMicros(data.getEndTimestamp());
            switch (data.getConnectivityData().getDefaultNetworkType()) {
                case WIFI: {
                    seriesData.add((SeriesData<RadioState>)new SeriesData(timestampUs, (Object)RadioState.WIFI));
                    continue block8;
                }
                case MOBILE: {
                    switch (data.getConnectivityData().getRadioState()) {
                        case HIGH: {
                            seriesData.add((SeriesData<RadioState>)new SeriesData(timestampUs, (Object)RadioState.HIGH));
                            continue block8;
                        }
                        case LOW: {
                            seriesData.add((SeriesData<RadioState>)new SeriesData(timestampUs, (Object)RadioState.LOW));
                            continue block8;
                        }
                    }
                    seriesData.add((SeriesData<RadioState>)new SeriesData(timestampUs, (Object)RadioState.NONE));
                    continue block8;
                }
            }
            seriesData.add((SeriesData<RadioState>)new SeriesData(timestampUs, (Object)RadioState.NONE));
        }
        ArrayList<SeriesData<RadioState>> arrayList = seriesData;
        if (arrayList == null) {
            NetworkRadioDataSeries.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/NetworkRadioDataSeries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/NetworkRadioDataSeries";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataForXRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDataForXRange";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum RadioState {
        WIFI,
        LOW,
        HIGH,
        NONE;

    }
}

