/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.ProfilerTooltipView;
import com.android.tools.profilers.network.NetworkProfilerStageView;
import com.android.tools.profilers.network.NetworkRadioTooltip;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class NetworkRadioTooltipView
extends ProfilerTooltipView {
    @NotNull
    private final NetworkRadioTooltip myTooltip;
    @NotNull
    private final ProfilerTimeline myTimeline;
    private JLabel myTimeRangeLabel;

    NetworkRadioTooltipView(@NotNull NetworkProfilerStageView view, @NotNull NetworkRadioTooltip tooltip) {
        if (view == null) {
            NetworkRadioTooltipView.$$$reportNull$$$0(0);
        }
        if (tooltip == null) {
            NetworkRadioTooltipView.$$$reportNull$$$0(1);
        }
        super(view.getTimeline(), "Network Radio");
        this.myTimeline = view.getTimeline();
        this.myTooltip = tooltip;
        tooltip.addDependency(this).onChange((Enum)NetworkRadioTooltip.Aspect.RADIO_STATE, this::timeChanged);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myTooltip.removeDependencies(this);
    }

    @Override
    protected void timeChanged() {
        NetworkRadioTooltip.RadioStateData radioStateData = this.myTooltip.getRadioStateData();
        if (radioStateData != null) {
            String min = TimeAxisFormatter.DEFAULT.getClockFormattedString((long)(radioStateData.getRadioStateRange().getMin() - this.myTimeline.getDataRange().getMin()));
            String max = TimeAxisFormatter.DEFAULT.getClockFormattedString((long)(radioStateData.getRadioStateRange().getMax() - this.myTimeline.getDataRange().getMin()));
            this.myHeadingLabel.setText(radioStateData.getRadioState().name());
            this.myTimeRangeLabel.setText(String.format("%s - %s", min, max));
            this.updateMaximumLabelDimensions();
        } else {
            this.myHeadingLabel.setText("");
            this.myTimeRangeLabel.setText("");
        }
    }

    @Override
    @NotNull
    protected JComponent createTooltip() {
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("*"));
        panel.setBackground(ProfilerColors.TOOLTIP_BACKGROUND);
        this.myTimeRangeLabel = new JLabel();
        this.myTimeRangeLabel.setForeground(ProfilerColors.TOOLTIP_TEXT);
        this.myTimeRangeLabel.setFont(this.myFont);
        panel.add((Component)this.myTimeRangeLabel, new TabularLayout.Constraint(0, 0));
        JPanel jPanel = panel;
        if (jPanel == null) {
            NetworkRadioTooltipView.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/NetworkRadioTooltipView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/NetworkRadioTooltipView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

