/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network.details;

import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TreeWalker;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.legend.FixedLegend;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.FeatureConfig;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.network.ConnectionsStateChart;
import com.android.tools.profilers.network.NetworkConnectionsModel;
import com.android.tools.profilers.network.NetworkState;
import com.android.tools.profilers.network.details.TabContent;
import com.android.tools.profilers.network.details.TabUiUtils;
import com.android.tools.profilers.network.httpdata.HttpData;
import com.android.tools.profilers.network.httpdata.Payload;
import com.android.tools.profilers.stacktrace.DataViewer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.BoldLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.File;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OverviewTabContent
extends TabContent {
    private static final LongFunction<String> TIME_FORMATTER = time -> time >= 0L ? StringUtil.formatDuration((long)TimeUnit.MICROSECONDS.toMillis(time)) : "*";
    private static final String ID_CONTENT_TYPE = "CONTENT_TYPE";
    private static final String ID_SIZE = "SIZE";
    private static final String ID_URL = "URL";
    private static final String ID_TIMING = "TIMING";
    private static final String ID_INITIATING_THREAD = "INITIATING_THREAD";
    private static final String ID_OTHER_THREADS = "OTHER_THREADS";
    private static final String ID_RESPONSE_PAYLOAD_VIEWER = "RESPONSE_PAYLOAD_VIEWER";
    private final FeatureConfig myFeatures;
    private final IdeProfilerComponents myComponents;
    private final NetworkConnectionsModel myModel;
    private JPanel myPanel;

    OverviewTabContent(@NotNull FeatureConfig features, @NotNull IdeProfilerComponents components, @NotNull NetworkConnectionsModel model) {
        if (features == null) {
            OverviewTabContent.$$$reportNull$$$0(0);
        }
        if (components == null) {
            OverviewTabContent.$$$reportNull$$$0(1);
        }
        if (model == null) {
            OverviewTabContent.$$$reportNull$$$0(2);
        }
        this.myFeatures = features;
        this.myComponents = components;
        this.myModel = model;
    }

    private static JComponent createFields(@NotNull HttpData httpData, @Nullable Dimension payloadDimension) {
        int contentLength;
        if (httpData == null) {
            OverviewTabContent.$$$reportNull$$$0(3);
        }
        JPanel myFieldsPanel = new JPanel((LayoutManager)new TabularLayout("Fit,20px,*").setVGap(TabUiUtils.SECTION_VGAP));
        int row = 0;
        myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Request")), new TabularLayout.Constraint(row, 0));
        myFieldsPanel.add((Component)new JLabel(HttpData.getUrlName(httpData.getUrl())), new TabularLayout.Constraint(row, 2));
        myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Method")), new TabularLayout.Constraint(++row, 0));
        myFieldsPanel.add((Component)new JLabel(httpData.getMethod()), new TabularLayout.Constraint(row, 2));
        HttpData.ResponseHeader responseHeader = httpData.getResponseHeader();
        if (responseHeader.getStatusCode() != -1) {
            myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Status")), new TabularLayout.Constraint(++row, 0));
            JLabel statusCode = new JLabel(String.valueOf(responseHeader.getStatusCode()));
            myFieldsPanel.add((Component)statusCode, new TabularLayout.Constraint(row, 2));
        }
        if (payloadDimension != null) {
            myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Dimension")), new TabularLayout.Constraint(++row, 0));
            JLabel dimension = new JLabel(String.format("%d x %d", (int)payloadDimension.getWidth(), (int)payloadDimension.getHeight()));
            myFieldsPanel.add((Component)dimension, new TabularLayout.Constraint(row, 2));
        }
        if (!responseHeader.getContentType().isEmpty()) {
            myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Content type")), new TabularLayout.Constraint(++row, 0));
            JLabel contentTypeLabel = new JLabel(responseHeader.getContentType().getMimeType());
            contentTypeLabel.setName(ID_CONTENT_TYPE);
            myFieldsPanel.add((Component)contentTypeLabel, new TabularLayout.Constraint(row, 2));
        }
        if ((contentLength = responseHeader.getContentLength()) != -1) {
            try {
                myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Size")), new TabularLayout.Constraint(++row, 0));
                JLabel contentLengthLabel = new JLabel(StringUtil.formatFileSize((long)contentLength));
                contentLengthLabel.setName(ID_SIZE);
                myFieldsPanel.add((Component)contentLengthLabel, new TabularLayout.Constraint(row, 2));
            }
            catch (NumberFormatException contentLengthLabel) {
                // empty catch block
            }
        }
        myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Initiating thread")), new TabularLayout.Constraint(++row, 0));
        JLabel initiatingThreadLabel = new JLabel(httpData.getJavaThreads().get(0).getName());
        initiatingThreadLabel.setName(ID_INITIATING_THREAD);
        myFieldsPanel.add((Component)initiatingThreadLabel, new TabularLayout.Constraint(row, 2));
        if (httpData.getJavaThreads().size() > 1) {
            StringBuilder otherThreadsBuilder = new StringBuilder();
            for (int i = 1; i < httpData.getJavaThreads().size(); ++i) {
                if (otherThreadsBuilder.length() > 0) {
                    otherThreadsBuilder.append(", ");
                }
                otherThreadsBuilder.append(httpData.getJavaThreads().get(i).getName());
            }
            myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Other threads")), new TabularLayout.Constraint(++row, 0));
            JLabel otherThreadsLabel = new JLabel(otherThreadsBuilder.toString());
            otherThreadsLabel.setName(ID_OTHER_THREADS);
            myFieldsPanel.add((Component)otherThreadsLabel, new TabularLayout.Constraint(row, 2));
        }
        NoWrapBoldLabel urlLabel = new NoWrapBoldLabel(ID_URL);
        urlLabel.setVerticalAlignment(1);
        myFieldsPanel.add((Component)((Object)urlLabel), new TabularLayout.Constraint(++row, 0));
        WrappedHyperlink hyperlink = new WrappedHyperlink(httpData.getUrl());
        hyperlink.setName(ID_URL);
        myFieldsPanel.add((Component)hyperlink, new TabularLayout.Constraint(row, 2));
        ++row;
        JSeparator separator = TabUiUtils.createSeparator();
        separator.setMinimumSize(separator.getPreferredSize());
        int gap = TabUiUtils.PAGE_VGAP - TabUiUtils.SECTION_VGAP - (int)separator.getPreferredSize().getHeight() / 2;
        JPanel separatorContainer = new JPanel((LayoutManager)new VerticalFlowLayout(0, gap));
        separatorContainer.add(separator);
        myFieldsPanel.add((Component)separatorContainer, new TabularLayout.Constraint(row, 0, 1, 3));
        NoWrapBoldLabel timingLabel = new NoWrapBoldLabel("Timing");
        timingLabel.setVerticalAlignment(1);
        myFieldsPanel.add((Component)((Object)timingLabel), new TabularLayout.Constraint(++row, 0));
        JComponent timingBar = OverviewTabContent.createTimingBar(httpData);
        timingBar.setName(ID_TIMING);
        myFieldsPanel.add((Component)timingBar, new TabularLayout.Constraint(row, 2));
        new TreeWalker((Component)myFieldsPanel).descendantStream().forEach(TabUiUtils::adjustFont);
        return myFieldsPanel;
    }

    @NotNull
    private static JComponent createTimingBar(@NotNull HttpData httpData) {
        if (httpData == null) {
            OverviewTabContent.$$$reportNull$$$0(4);
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        Range range = new Range((double)httpData.getStartTimeUs(), httpData.getEndTimeUs() > 0L ? (double)httpData.getEndTimeUs() : (double)(httpData.getStartTimeUs() + 1L));
        ConnectionsStateChart connectionsChart = new ConnectionsStateChart(httpData, range);
        connectionsChart.getComponent().setMinimumSize(new Dimension(0, JBUI.scale((int)28)));
        connectionsChart.setHeightGap(0.0f);
        panel.add(connectionsChart.getComponent());
        long sentTime = -1L;
        long receivedTime = -1L;
        if (httpData.getDownloadingTimeUs() > 0L) {
            sentTime = httpData.getDownloadingTimeUs() - httpData.getStartTimeUs();
            receivedTime = httpData.getEndTimeUs() - httpData.getDownloadingTimeUs();
        } else if (httpData.getEndTimeUs() > 0L) {
            sentTime = httpData.getEndTimeUs() - httpData.getStartTimeUs();
            receivedTime = 0L;
        }
        FixedLegend sentLegend = new FixedLegend("Sent", TIME_FORMATTER.apply(sentTime));
        FixedLegend receivedLegend = new FixedLegend("Received", TIME_FORMATTER.apply(receivedTime));
        LegendComponentModel legendModel = new LegendComponentModel(100);
        legendModel.add((Legend)sentLegend);
        legendModel.add((Legend)receivedLegend);
        LegendComponent legend = new LegendComponent.Builder(legendModel).setLeftPadding(0).setVerticalPadding(JBUI.scale((int)8)).build();
        legend.setFont(legend.getFont().deriveFont(11.0f));
        legend.configure((Legend)sentLegend, new LegendConfig(LegendConfig.IconType.BOX, connectionsChart.getColors().getColor((Enum)NetworkState.SENDING)));
        legend.configure((Legend)receivedLegend, new LegendConfig(LegendConfig.IconType.BOX, connectionsChart.getColors().getColor((Enum)NetworkState.RECEIVING)));
        legendModel.update(1L);
        panel.add((Component)legend);
        JPanel jPanel = panel;
        if (jPanel == null) {
            OverviewTabContent.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = this.myFeatures.isNetworkRequestPayloadEnabled() ? "Overview" : "Response";
        if (string == null) {
            OverviewTabContent.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    protected JComponent createComponent() {
        final TabularLayout layout = new TabularLayout("*").setVGap(TabUiUtils.PAGE_VGAP);
        this.myPanel = new JPanel((LayoutManager)layout);
        this.myPanel.setBorder(BorderFactory.createEmptyBorder(TabUiUtils.PAGE_VGAP, TabUiUtils.HGAP, 0, TabUiUtils.HGAP));
        final JBScrollPane overviewScroll = TabUiUtils.createVerticalScrollPane(this.myPanel);
        overviewScroll.getVerticalScrollBar().setUnitIncrement(TabUiUtils.SCROLL_UNIT);
        overviewScroll.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                layout.setRowSizing(0, new TabularLayout.SizingRule(TabularLayout.SizingRule.Type.FIXED, (int)((float)overviewScroll.getViewport().getHeight() * 0.4f)));
                layout.layoutContainer((Container)OverviewTabContent.this.myPanel);
            }
        });
        JBScrollPane jBScrollPane = overviewScroll;
        if (jBScrollPane == null) {
            OverviewTabContent.$$$reportNull$$$0(7);
        }
        return jBScrollPane;
    }

    @Override
    public void populateFor(@Nullable HttpData data) {
        this.myPanel.removeAll();
        if (data == null) {
            return;
        }
        File payloadFile = Payload.newResponsePayload(this.myModel, data).toFile();
        DataViewer fileViewer = this.myComponents.createFileViewer(payloadFile);
        JComponent responsePayloadComponent = fileViewer.getComponent();
        responsePayloadComponent.setName(ID_RESPONSE_PAYLOAD_VIEWER);
        this.myPanel.add((Component)responsePayloadComponent, new TabularLayout.Constraint(0, 0));
        this.myPanel.add((Component)OverviewTabContent.createFields(data, fileViewer.getDimension()), new TabularLayout.Constraint(1, 0));
    }

    @Override
    public void trackWith(@NotNull FeatureTracker featureTracker) {
        if (featureTracker == null) {
            OverviewTabContent.$$$reportNull$$$0(8);
        }
        if (this.myFeatures.isNetworkRequestPayloadEnabled()) {
            featureTracker.trackSelectNetworkDetailsOverview();
        } else {
            featureTracker.trackSelectNetworkDetailsResponse();
        }
    }

    @Nullable
    @VisibleForTesting
    JComponent findResponsePayloadViewer() {
        return TabUiUtils.findComponentWithUniqueName(this.myPanel, ID_RESPONSE_PAYLOAD_VIEWER);
    }

    @Nullable
    @VisibleForTesting
    JLabel findContentTypeValue() {
        return (JLabel)TabUiUtils.findComponentWithUniqueName(this.myPanel, ID_CONTENT_TYPE);
    }

    @Nullable
    @VisibleForTesting
    JLabel findSizeValue() {
        return (JLabel)TabUiUtils.findComponentWithUniqueName(this.myPanel, ID_SIZE);
    }

    @Nullable
    @VisibleForTesting
    JTextArea findUrlValue() {
        return (JTextArea)TabUiUtils.findComponentWithUniqueName(this.myPanel, ID_URL);
    }

    @Nullable
    @VisibleForTesting
    JComponent findTimingBar() {
        return TabUiUtils.findComponentWithUniqueName(this.myPanel, ID_TIMING);
    }

    @Nullable
    @VisibleForTesting
    JLabel findInitiatingThreadValue() {
        return (JLabel)TabUiUtils.findComponentWithUniqueName(this.myPanel, ID_INITIATING_THREAD);
    }

    @Nullable
    @VisibleForTesting
    JLabel findOtherThreadsValue() {
        return (JLabel)TabUiUtils.findComponentWithUniqueName(this.myPanel, ID_OTHER_THREADS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "features";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "httpData";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/details/OverviewTabContent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/details/OverviewTabContent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTimingBar";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFields";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTimingBar";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "trackWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WrappedHyperlink
    extends JTextArea {
        WrappedHyperlink(@NotNull String url) {
            if (url == null) {
                WrappedHyperlink.$$$reportNull$$$0(0);
            }
            super(url);
            this.setLineWrap(true);
            this.setEditable(false);
            this.setBackground(UIUtil.getLabelBackground());
            this.setFont(UIManager.getFont("Label.font").deriveFont(11.0f).deriveFont((Map<? extends AttributedCharacterIterator.Attribute, ?>)ImmutableMap.of((Object)TextAttribute.FOREGROUND, (Object)PlatformColors.BLUE, (Object)TextAttribute.BACKGROUND, (Object)UIUtil.getLabelBackground())));
            MouseAdapter mouseAdapter = this.getMouseAdapter(url);
            this.addMouseListener(mouseAdapter);
            this.addMouseMotionListener(mouseAdapter);
        }

        private MouseAdapter getMouseAdapter(final String url) {
            return new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    this.mouseMoved(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    this.setCursor(Cursor.getDefaultCursor());
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (this.isMouseOverText(e)) {
                        BrowserUtil.browse((String)url);
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.setCursor(this.isMouseOverText(e) ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
                }

                private boolean isMouseOverText(MouseEvent e) {
                    return this.viewToModel(e.getPoint()) < this.getDocument().getLength();
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/android/tools/profilers/network/details/OverviewTabContent$WrappedHyperlink", "<init>"));
        }
    }

    static final class NoWrapBoldLabel
    extends BoldLabel {
        NoWrapBoldLabel(String text) {
            super("<nobr>" + text + "</nobr>");
        }
    }
}

