/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network.details;

import com.android.tools.adtui.TreeWalker;
import com.android.tools.adtui.ui.HideablePanel;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.SizeRequirements;
import javax.swing.UIManager;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TabUiUtils {
    public static final int SCROLL_UNIT = JBUI.scale((int)10);
    public static final float FIELD_FONT_SIZE = 11.0f;
    public static final int TAB_SECTION_VGAP = JBUI.scale((int)5);
    public static final int PAGE_VGAP = JBUI.scale((int)28);
    public static final int SECTION_VGAP = JBUI.scale((int)10);
    public static final int HGAP = JBUI.scale((int)22);
    public static final float TITLE_FONT_SIZE = 14.0f;
    public static final String SECTION_TITLE_HEADERS = "Headers";

    private TabUiUtils() {
    }

    @NotNull
    public static JPanel createVerticalPanel(int verticalGap) {
        JPanel jPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, verticalGap));
        if (jPanel == null) {
            TabUiUtils.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @NotNull
    public static JBScrollPane createScrollPane(@NotNull JComponent component) {
        if (component == null) {
            TabUiUtils.$$$reportNull$$$0(1);
        }
        JBScrollPane scrollPane = new JBScrollPane((Component)component);
        scrollPane.getVerticalScrollBar().setUnitIncrement(SCROLL_UNIT);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(SCROLL_UNIT);
        JBScrollPane jBScrollPane = scrollPane;
        if (jBScrollPane == null) {
            TabUiUtils.$$$reportNull$$$0(2);
        }
        return jBScrollPane;
    }

    @NotNull
    public static JBScrollPane createVerticalScrollPane(@NotNull JComponent component) {
        if (component == null) {
            TabUiUtils.$$$reportNull$$$0(3);
        }
        JBScrollPane scrollPane = TabUiUtils.createScrollPane(component);
        scrollPane.setHorizontalScrollBarPolicy(31);
        JBScrollPane jBScrollPane = scrollPane;
        if (jBScrollPane == null) {
            TabUiUtils.$$$reportNull$$$0(4);
        }
        return jBScrollPane;
    }

    @NotNull
    public static JBScrollPane createNestedScrollPane(@NotNull JComponent component) {
        if (component == null) {
            TabUiUtils.$$$reportNull$$$0(5);
        }
        JBScrollPane scrollPane = TabUiUtils.createScrollPane(component);
        scrollPane.setVerticalScrollBarPolicy(21);
        scrollPane.addMouseWheelListener((MouseWheelListener)new DelegateMouseWheelListener((JScrollPane)scrollPane));
        JBScrollPane jBScrollPane = scrollPane;
        if (jBScrollPane == null) {
            TabUiUtils.$$$reportNull$$$0(6);
        }
        return jBScrollPane;
    }

    @NotNull
    public static JSeparator createSeparator() {
        JSeparator separator = new JSeparator();
        separator.setForeground(UIManager.getColor("Table.gridColor"));
        JSeparator jSeparator = separator;
        if (jSeparator == null) {
            TabUiUtils.$$$reportNull$$$0(7);
        }
        return jSeparator;
    }

    @NotNull
    public static HideablePanel createHideablePanel(@NotNull String title, @NotNull JComponent content, @Nullable JComponent northEastComponent) {
        if (title == null) {
            TabUiUtils.$$$reportNull$$$0(8);
        }
        if (content == null) {
            TabUiUtils.$$$reportNull$$$0(9);
        }
        title = String.format("<html><b>%s</b></html>", title);
        HideablePanel hideablePanel = new HideablePanel.Builder(title, content).setNorthEastComponent(northEastComponent).build();
        if (hideablePanel == null) {
            TabUiUtils.$$$reportNull$$$0(10);
        }
        return hideablePanel;
    }

    @NotNull
    public static JComponent createStyledMapComponent(@NotNull Map<String, String> map) {
        if (map == null) {
            TabUiUtils.$$$reportNull$$$0(11);
        }
        if (map.isEmpty()) {
            JLabel jLabel = new JLabel("No data available");
            if (jLabel == null) {
                TabUiUtils.$$$reportNull$$$0(12);
            }
            return jLabel;
        }
        JEditorPane htmlTextPane = new JEditorPane();
        htmlTextPane.setContentType("text/html");
        BreakWordWrapHTMLEditorKit editorKit = new BreakWordWrapHTMLEditorKit();
        htmlTextPane.setEditorKit(editorKit);
        StyleSheet styleSheet = editorKit.getStyleSheet();
        Font labelFont = UIManager.getFont("Label.font");
        styleSheet.addRule("body { font-family: " + labelFont.getFamily() + "; font-size: " + 11.0f + "pt; }");
        styleSheet.addRule("p { margin: 4 0 4 0; }");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append("<p><b>").append(entry.getKey()).append(":&nbsp&nbsp</b>");
            stringBuilder.append("<span>").append(entry.getValue()).append("</span></p>");
        }
        stringBuilder.append("</html>");
        htmlTextPane.setText(stringBuilder.toString());
        JEditorPane jEditorPane = htmlTextPane;
        if (jEditorPane == null) {
            TabUiUtils.$$$reportNull$$$0(13);
        }
        return jEditorPane;
    }

    @NotNull
    public static JComponent createMapComponent(@NotNull Map<String, String> argsMap) {
        if (argsMap == null) {
            TabUiUtils.$$$reportNull$$$0(14);
        }
        if (argsMap.isEmpty()) {
            JLabel jLabel = new JLabel("No data available");
            if (jLabel == null) {
                TabUiUtils.$$$reportNull$$$0(15);
            }
            return jLabel;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        for (Map.Entry<String, String> entry : argsMap.entrySet()) {
            stringBuilder.append("<p><nobr><b>").append(entry.getKey()).append(":&nbsp&nbsp</b></nobr>");
            stringBuilder.append("<span>").append(entry.getValue()).append("</span></p>");
        }
        stringBuilder.append("</html>");
        JTextPane jTextPane = TabUiUtils.createTextPane(stringBuilder.toString());
        if (jTextPane == null) {
            TabUiUtils.$$$reportNull$$$0(16);
        }
        return jTextPane;
    }

    @NotNull
    private static JTextPane createTextPane(String text) {
        JTextPane textPane = new JTextPane();
        textPane.setContentType("text/html");
        textPane.setBackground(null);
        textPane.setBorder(null);
        textPane.setEditable(false);
        textPane.setText(text);
        Font labelFont = UIManager.getFont("Label.font");
        String rule = "body { font-family: " + labelFont.getFamily() + "; font-size: " + 11.0f + "pt; }";
        ((HTMLDocument)textPane.getDocument()).getStyleSheet().addRule(rule);
        JTextPane jTextPane = textPane;
        if (jTextPane == null) {
            TabUiUtils.$$$reportNull$$$0(17);
        }
        return jTextPane;
    }

    public static void adjustFont(@NotNull Component c) {
        if (c == null) {
            TabUiUtils.$$$reportNull$$$0(18);
        }
        if (c.getFont() == null) {
            return;
        }
        c.setFont(c.getFont().deriveFont(0, 11.0f));
    }

    @Nullable
    public static JComponent findComponentWithUniqueName(@NotNull JComponent root, @NotNull String name) {
        List matches;
        if (root == null) {
            TabUiUtils.$$$reportNull$$$0(19);
        }
        if (name == null) {
            TabUiUtils.$$$reportNull$$$0(20);
        }
        if ((matches = new TreeWalker((Component)root).descendantStream().filter(c -> {
            if (name == null) {
                TabUiUtils.$$$reportNull$$$0(21);
            }
            return name.equals(c.getName());
        }).collect(Collectors.toList())).size() > 1) {
            throw new IllegalStateException("More than one component found with the name: " + name);
        }
        return matches.size() == 1 ? (JComponent)matches.get(0) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/details/TabUiUtils";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argsMap";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVerticalPanel";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/details/TabUiUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createScrollPane";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createVerticalScrollPane";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createNestedScrollPane";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSeparator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createHideablePanel";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createStyledMapComponent";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createMapComponent";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextPane";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createScrollPane";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createVerticalScrollPane";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNestedScrollPane";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createHideablePanel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createStyledMapComponent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createMapComponent";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "adjustFont";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findComponentWithUniqueName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findComponentWithUniqueName$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BreakWordWrapHTMLEditorKit
    extends HTMLEditorKit {
        private BreakWordWrapHTMLEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return new HTMLEditorKit.HTMLFactory(){

                @Override
                public View create(Element e) {
                    View v = super.create(e);
                    if (v instanceof InlineView) {
                        return new InlineView(e){

                            @Override
                            public int getBreakWeight(int axis, float pos, float len) {
                                return 1000;
                            }

                            @Override
                            public View breakView(int axis, int p0, float pos, float len) {
                                if (axis == 0) {
                                    this.checkPainter();
                                    int p1 = this.getGlyphPainter().getBoundedPosition(this, p0, pos, len);
                                    if (p0 == this.getStartOffset() && p1 == this.getEndOffset()) {
                                        return this;
                                    }
                                    return this.createFragment(p0, p1);
                                }
                                return this;
                            }
                        };
                    }
                    if (v instanceof ParagraphView) {
                        return new ParagraphView(e){

                            @Override
                            protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
                                if (r == null) {
                                    r = new SizeRequirements();
                                }
                                float pref = this.layoutPool.getPreferredSpan(axis);
                                float min = this.layoutPool.getMinimumSpan(axis);
                                r.minimum = (int)min;
                                r.preferred = Math.max(r.minimum, (int)pref);
                                r.maximum = Integer.MAX_VALUE;
                                r.alignment = 0.5f;
                                return r;
                            }
                        };
                    }
                    return v;
                }
            };
        }
    }

    static class DelegateMouseWheelListener
    implements MouseWheelListener {
        @NotNull
        private final JScrollPane myScrollPane;
        @Nullable
        private JScrollPane myParentScrollPane;
        private int myLastScrollOffset;

        DelegateMouseWheelListener(@NotNull JScrollPane scrollPane) {
            if (scrollPane == null) {
                DelegateMouseWheelListener.$$$reportNull$$$0(0);
            }
            this.myLastScrollOffset = 0;
            this.myScrollPane = scrollPane;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int terminalValue;
            this.setParentScrollPane();
            if (this.myParentScrollPane == null) {
                this.myScrollPane.removeMouseWheelListener(this);
                return;
            }
            JScrollBar scrollBar = this.myScrollPane.getVerticalScrollBar();
            int n = terminalValue = e.getWheelRotation() < 0 ? 0 : scrollBar.getMaximum() - scrollBar.getVisibleAmount();
            if (scrollBar.getValue() == terminalValue && this.myLastScrollOffset == terminalValue) {
                this.myParentScrollPane.dispatchEvent(DelegateMouseWheelListener.clone(this.myParentScrollPane, e));
            }
            this.myLastScrollOffset = scrollBar.getValue();
        }

        private void setParentScrollPane() {
            if (this.myParentScrollPane == null) {
                Container parent;
                for (parent = this.myScrollPane.getParent(); parent != null && !(parent instanceof JScrollPane); parent = parent.getParent()) {
                }
                this.myParentScrollPane = (JScrollPane)parent;
            }
        }

        private static MouseWheelEvent clone(JScrollPane source, MouseWheelEvent e) {
            return new MouseWheelEvent((Component)source, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), e.getWheelRotation());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollPane", "com/android/tools/profilers/network/details/TabUiUtils$DelegateMouseWheelListener", "<init>"));
        }
    }
}

