/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.idea.common.resources.Icons;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.git.utils.TfGitHelper;
import git4idea.GitUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.net.URI;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenCommitInBrowserAction
extends DumbAwareAction {
    private static final Logger logger = LoggerFactory.getLogger(OpenCommitInBrowserAction.class);

    public OpenCommitInBrowserAction() {
        super(TfPluginBundle.message("Actions.OpenInBrowser.Title", new Object[0]), TfPluginBundle.message("Actions.OpenInBrowser.Message", new Object[0]), Icons.VSLogoSmall);
    }

    public void update(@NotNull AnActionEvent anActionEvent) {
        if (anActionEvent == null) {
            OpenCommitInBrowserAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = anActionEvent.getPresentation();
        Project project = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)anActionEvent.getData(VcsLogDataKeys.VCS_LOG);
        if (project == null || project.isDisposed() || log == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        List commits = log.getSelectedDetails();
        if (commits.size() == 0) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        VcsFullCommitDetails commit = (VcsFullCommitDetails)commits.get(0);
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForRoot(commit.getRoot());
        if (repository == null || !TfGitHelper.isTfGitRepository(repository)) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        if (commits.size() > 1) {
            presentation.setVisible(true);
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        if (anActionEvent == null) {
            OpenCommitInBrowserAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)anActionEvent.getRequiredData(CommonDataKeys.PROJECT);
        VcsFullCommitDetails commit = (VcsFullCommitDetails)((VcsLog)anActionEvent.getRequiredData(VcsLogDataKeys.VCS_LOG)).getSelectedDetails().get(0);
        GitRepository gitRepository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForRoot(commit.getRoot());
        GitRemote remote = TfGitHelper.getTfGitRemote(gitRepository);
        if (remote == null) {
            return;
        }
        String remoteUrl = remote.getFirstUrl();
        if (remoteUrl == null) {
            return;
        }
        URI urlToBrowseTo = UrlHelper.getCommitURI((String)remoteUrl, (String)((Hash)commit.getId()).toString());
        logger.info("Browsing to url " + urlToBrowseTo.getPath());
        BrowserUtil.browse((URI)urlToBrowseTo);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "anActionEvent";
        objectArray2[1] = "com/microsoft/alm/plugin/idea/common/actions/OpenCommitInBrowserAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

