/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.idea.common.resources.Icons;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.git.utils.TfGitHelper;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFileInBrowserAction
extends DumbAwareAction {
    private static final Logger logger = LoggerFactory.getLogger(OpenFileInBrowserAction.class);

    protected OpenFileInBrowserAction() {
        super(TfPluginBundle.message("Actions.OpenInBrowser.Title", new Object[0]), TfPluginBundle.message("Actions.OpenInBrowser.Message", new Object[0]), Icons.VSLogoSmall);
    }

    public void update(@NotNull AnActionEvent anActionEvent) {
        if (anActionEvent == null) {
            OpenFileInBrowserAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = anActionEvent.getPresentation();
        Project project = anActionEvent.getProject();
        if (project == null || project.isDisposed()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        VirtualFile[] vFiles = (VirtualFile[])anActionEvent.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (vFiles == null || vFiles.length == 0 || vFiles[0] == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        if (vFiles.length > 1) {
            presentation.setEnabled(false);
            GitRepositoryManager manager = GitUtil.getRepositoryManager((Project)project);
            for (VirtualFile vFile : vFiles) {
                GitRepository repository = (GitRepository)manager.getRepositoryForFile(vFile);
                if (repository == null || !TfGitHelper.isTfGitRepository(repository)) continue;
                presentation.setVisible(true);
                return;
            }
            presentation.setVisible(false);
            return;
        }
        VirtualFile vFile = vFiles[0];
        GitRepositoryManager manager = GitUtil.getRepositoryManager((Project)project);
        try {
            GitRepository repository = (GitRepository)manager.getRepositoryForFile(vFile);
            if (repository == null || !TfGitHelper.isTfGitRepository(repository)) {
                presentation.setEnabledAndVisible(false);
                return;
            }
        }
        catch (InvalidVirtualFileAccessException e) {
            logger.warn("Exception caught while trying to find file's repo", (Throwable)e);
            return;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        if (changeListManager.isIgnoredFile(vFile)) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setVisible(true);
        presentation.setEnabled(this.isEnabled(changeListManager, project, vFile));
    }

    private boolean isEnabled(ChangeListManager changeListManager, Project project, VirtualFile vFile) {
        if (vFile.isDirectory()) {
            return true;
        }
        GitVcs vcs = GitVcs.getInstance((Project)project);
        if (!ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)vcs, new VirtualFile[]{vFile})) {
            return false;
        }
        if (changeListManager.isUnversioned(vFile)) {
            return false;
        }
        Change change = changeListManager.getChange(vFile);
        return change == null || change.getType() != Change.Type.NEW;
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        GitRemoteBranch gitRemoteBranch;
        Project project = (Project)anActionEvent.getRequiredData(CommonDataKeys.PROJECT);
        VirtualFile virtualFile = (VirtualFile)anActionEvent.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        GitRepositoryManager manager = GitUtil.getRepositoryManager((Project)project);
        GitRepository gitRepository = (GitRepository)manager.getRepositoryForFile(virtualFile);
        GitRemote gitRemote = TfGitHelper.getTfGitRemote(gitRepository);
        if (gitRemote == null || gitRepository == null || gitRepository.getRoot() == null) {
            return;
        }
        String rootPath = gitRepository.getRoot().getPath();
        String path = virtualFile.getPath();
        String relativePath = path.substring(rootPath.length());
        String gitRemoteBranchName = "";
        GitLocalBranch gitLocalBranch = gitRepository.getCurrentBranch();
        if (gitLocalBranch != null && (gitRemoteBranch = gitLocalBranch.findTrackedBranch(gitRepository)) != null) {
            gitRemoteBranchName = gitRemoteBranch.getNameForRemoteOperations();
        }
        URI urlToBrowseTo = UrlHelper.getFileURI((String)gitRemote.getFirstUrl(), (String)this.encodeVirtualFilePath(relativePath), (String)gitRemoteBranchName);
        logger.info("Browsing to url " + urlToBrowseTo.getPath());
        BrowserUtil.browse((URI)urlToBrowseTo);
    }

    private String encodeVirtualFilePath(String virtualFilePath) {
        String UTF_8 = "UTF-8";
        String path = FileUtil.toSystemIndependentName((String)virtualFilePath);
        try {
            return URLEncoder.encode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.warn(virtualFilePath, (Throwable)e);
            return path;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anActionEvent", "com/microsoft/alm/plugin/idea/common/actions/OpenFileInBrowserAction", "update"));
    }
}

