/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.CommitMessageI;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.microsoft.alm.plugin.idea.common.resources.Icons;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.workitem.SelectWorkItemsDialog;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.idea.common.utils.VcsHelper;
import com.microsoft.alm.plugin.idea.git.utils.TfGitHelper;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectWorkItemsAction
extends DumbAwareAction {
    public static final Logger logger = LoggerFactory.getLogger(SelectWorkItemsAction.class);

    public SelectWorkItemsAction() {
        super(TfPluginBundle.message("Actions.SelectWorkItems.Title", new Object[0]), TfPluginBundle.message("Actions.SelectWorkItems.Message", new Object[0]), Icons.WIT_ADD);
    }

    public void update(AnActionEvent anActionEvent) {
        boolean disableButton;
        Project project = (Project)CommonDataKeys.PROJECT.getData(anActionEvent.getDataContext());
        if (IdeaHelper.isRider() && !VcsHelper.isVstsRepo(project)) {
            anActionEvent.getPresentation().setVisible(false);
            return;
        }
        anActionEvent.getPresentation().setVisible(true);
        try {
            disableButton = project == null || TfGitHelper.getTfGitRepository(project) == null && TFSVcs.getInstance(project) == null || VcsHelper.getRepositoryContext(project) == null;
        }
        catch (Exception e) {
            logger.warn("Exception finding if project is TFS for work item association", (Throwable)e);
            disableButton = true;
        }
        if (disableButton) {
            anActionEvent.getPresentation().setEnabled(false);
            anActionEvent.getPresentation().setText(TfPluginBundle.message("Errors.NotTfsRepo", TfPluginBundle.message("Actions.SelectWorkItems.Action", new Object[0])));
        } else {
            anActionEvent.getPresentation().setEnabled(true);
            anActionEvent.getPresentation().setText(TfPluginBundle.message("Actions.SelectWorkItems.Title", new Object[0]));
        }
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        CommitMessageI commitMessageI;
        DataContext dc = anActionEvent.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dc);
        Refreshable panel = (Refreshable)CheckinProjectPanel.PANEL_KEY.getData(dc);
        CommitMessageI commitMessageI2 = commitMessageI = panel instanceof CommitMessageI ? (CommitMessageI)panel : (CommitMessageI)VcsDataKeys.COMMIT_MESSAGE_CONTROL.getData(dc);
        if (commitMessageI != null && project != null) {
            SelectWorkItemsDialog dialog;
            String commitMessage = "";
            if (commitMessageI instanceof CommitChangeListDialog) {
                commitMessage = ((CommitChangeListDialog)commitMessageI).getCommitMessage();
            }
            if ((dialog = new SelectWorkItemsDialog(project)).showAndGet()) {
                commitMessage = StringUtils.isNotEmpty((String)commitMessage) ? commitMessage + "\n" + dialog.getComment() : dialog.getComment();
                commitMessageI.setCommitMessage(commitMessage);
            }
        }
    }
}

