/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.extensions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.util.NotNullFunction;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.workitem.VcsWorkItemsController;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.idea.common.utils.VcsHelper;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcsWorkItemContentProvider
implements ChangesViewContentProvider {
    private static final Logger logger = LoggerFactory.getLogger(VcsWorkItemContentProvider.class);
    private VcsWorkItemsController controller;
    private Throwable t;

    public VcsWorkItemContentProvider(@NotNull Project project) {
        if (project == null) {
            VcsWorkItemContentProvider.$$$reportNull$$$0(0);
        }
        try {
            this.controller = new VcsWorkItemsController(project);
        }
        catch (Throwable t) {
            this.t = t;
            this.controller = null;
            logger.error("VcsWorkItemContentProvider: unexpected fatal error initializing the controller", t);
        }
    }

    public JComponent initContent() {
        if (this.controller != null) {
            return this.controller.getPanel();
        }
        return new JLabel(TfPluginBundle.message("VcsWorkItemsTab.Unexpected.Errors", this.t != null ? this.t.getMessage() : ""), AllIcons.General.Warning, 0);
    }

    public void disposeContent() {
        if (this.controller != null) {
            this.controller.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/microsoft/alm/plugin/idea/common/extensions/VcsWorkItemContentProvider", "<init>"));
    }

    public static class VcsWorkItemVisibilityPredicate
    implements NotNullFunction<Project, Boolean> {
        @NotNull
        public Boolean fun(Project project) {
            if (!VcsHelper.isGitVcs(project) && !VcsHelper.isTfVcs(project)) {
                Boolean bl = false;
                if (bl == null) {
                    VcsWorkItemVisibilityPredicate.$$$reportNull$$$0(0);
                }
                return bl;
            }
            Boolean bl = IdeaHelper.isRider() ? VcsHelper.isVstsRepo(project) : true;
            if (bl == null) {
                VcsWorkItemVisibilityPredicate.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/microsoft/alm/plugin/idea/common/extensions/VcsWorkItemContentProvider$VcsWorkItemVisibilityPredicate", "fun"));
        }
    }
}

