/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.settings;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonHelper {
    private static final Logger logger = LoggerFactory.getLogger(JsonHelper.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static <T> String write(T object) {
        String json = null;
        if (object != null) {
            try {
                json = mapper.writeValueAsString(object);
            }
            catch (JsonProcessingException e) {
                logger.warn("Failed to convert to string", (Throwable)e);
            }
        }
        return json;
    }

    public static <T> T read(String json, Class<T> valueType) throws IOException {
        Object object = null;
        if (json != null) {
            object = mapper.readValue(json, valueType);
        }
        return (T)object;
    }
}

