/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.settings;

import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.core.webapi.model.TeamProjectCollectionReference;
import com.microsoft.alm.core.webapi.model.TeamProjectReference;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextBuilder;
import com.microsoft.alm.plugin.idea.common.settings.JsonHelper;
import com.microsoft.alm.sourcecontrol.webapi.model.GitRepository;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;

public class ServerContextState {
    public ServerContext.Type type = null;
    public String uri = null;
    public String serverUri = null;
    public String userId = null;
    public String teamProjectCollectionReference = null;
    public String teamProjectReference = null;
    public String gitRepository = null;

    public ServerContextState() {
    }

    public ServerContextState(ServerContext context) {
        this();
        this.type = context.getType();
        this.uri = UrlHelper.asString((URI)context.getUri());
        this.serverUri = UrlHelper.asString((URI)context.getServerUri());
        this.userId = this.restrict(context.getUserId());
        this.teamProjectCollectionReference = JsonHelper.write(this.restrict(context.getTeamProjectCollectionReference()));
        this.teamProjectReference = JsonHelper.write(this.restrict(context.getTeamProjectReference()));
        this.gitRepository = JsonHelper.write(context.getGitRepository());
    }

    public ServerContextBuilder createBuilder() throws IOException {
        return new ServerContextBuilder().type(this.type).uri(this.uri).serverUri(this.serverUri).userId(this.userId).collection(JsonHelper.read(this.teamProjectCollectionReference, TeamProjectCollectionReference.class)).teamProject(JsonHelper.read(this.teamProjectReference, TeamProjectReference.class)).repository(JsonHelper.read(this.gitRepository, GitRepository.class));
    }

    private TeamProjectCollectionReference restrict(TeamProjectCollectionReference reference) {
        TeamProjectCollectionReference newReference = new TeamProjectCollectionReference();
        if (reference != null) {
            newReference.setName(reference.getName());
            newReference.setId(reference.getId());
            newReference.setUrl(reference.getUrl());
        }
        return newReference;
    }

    private TeamProjectReference restrict(TeamProjectReference reference) {
        TeamProjectReference newReference = new TeamProjectReference();
        if (reference != null) {
            newReference.setName(reference.getName());
            newReference.setId(reference.getId());
            newReference.setUrl(reference.getUrl());
            newReference.setAbbreviation(reference.getAbbreviation());
            newReference.setDescription(reference.getDescription());
            newReference.setRevision(reference.getRevision());
            newReference.setState(reference.getState());
        }
        return newReference;
    }

    private String restrict(UUID userId) {
        if (userId != null) {
            return userId.toString();
        }
        return "";
    }
}

