/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.settings;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.common.settings.JsonHelper;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamServicesSecrets {
    private static final Logger logger = LoggerFactory.getLogger(TeamServicesSecrets.class);

    public static void forget(String key) {
        TeamServicesSecrets.forgetPassword(key);
    }

    public static AuthenticationInfo load(String key) throws IOException {
        String authInfoSerialized = TeamServicesSecrets.readPassword(key);
        AuthenticationInfo info = null;
        if (StringUtils.isNotEmpty((String)authInfoSerialized)) {
            info = JsonHelper.read(authInfoSerialized, AuthenticationInfo.class);
        }
        if (info == null) {
            TeamServicesSecrets.forget(key);
            logger.warn("getServerContextSecrets: info was null for key: ", (Object)key);
            return null;
        }
        return info;
    }

    public static void save(ServerContext context) {
        if (context == null) {
            return;
        }
        String key = context.getKey();
        AuthenticationInfo authenticationInfo = context.getAuthenticationInfo();
        String stringValue = JsonHelper.write(authenticationInfo);
        TeamServicesSecrets.writePassword(key, stringValue);
    }

    private static void forgetPassword(String key) {
        TeamServicesSecrets.writePassword(key, null);
    }

    private static void writePassword(String key, String value) {
        try {
            CredentialAttributes attributes = new CredentialAttributes(key);
            Credentials credentials = new Credentials(key, value);
            PasswordSafe.getInstance().set(attributes, credentials);
        }
        catch (NoClassDefFoundError error) {
            logger.warn("Failed to write password using new implementation so attempting old way", (Throwable)error);
            TeamServicesSecrets.writePasswordOldWay(key, value);
        }
        catch (NoSuchMethodError error) {
            logger.warn("Failed to write password using new implementation so attempting old way", (Throwable)error);
            TeamServicesSecrets.writePasswordOldWay(key, value);
        }
    }

    private static void writePasswordOldWay(String key, String value) {
        try {
            PasswordSafe.getInstance().storePassword(null, TeamServicesSecrets.class, key, value);
        }
        catch (PasswordSafeException e) {
            logger.warn("Failed to write password", (Throwable)e);
        }
        catch (Throwable t) {
            logger.warn("Failed to write password", t);
        }
    }

    private static String readPassword(String key) {
        String password = "";
        try {
            CredentialAttributes attributes = new CredentialAttributes(key);
            Credentials credentials = PasswordSafe.getInstance().get(attributes);
            password = credentials != null ? credentials.getPasswordAsString() : password;
        }
        catch (NoClassDefFoundError error) {
            logger.warn("Failed to get password using new implementation so attempting old way", (Throwable)error);
            password = TeamServicesSecrets.readPasswordOldWay(key);
        }
        catch (NoSuchMethodError error) {
            logger.warn("Failed to get password using new implementation so attempting old way", (Throwable)error);
            password = TeamServicesSecrets.readPasswordOldWay(key);
        }
        return password;
    }

    private static String readPasswordOldWay(String key) {
        try {
            return PasswordSafe.getInstance().getPassword(null, TeamServicesSecrets.class, key);
        }
        catch (PasswordSafeException e) {
            logger.warn("Failed to read password", (Throwable)e);
        }
        catch (Throwable t) {
            logger.warn("Failed to read password", t);
        }
        return "";
    }
}

