/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.settings;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.idea.common.services.PropertyServiceImpl;
import com.microsoft.alm.plugin.idea.common.settings.PropertyState;
import com.microsoft.alm.plugin.idea.common.settings.ServerContextState;
import com.microsoft.alm.plugin.idea.common.settings.SettingsState;
import com.microsoft.alm.plugin.idea.common.settings.TeamServicesSecrets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@State(name="VSTSSettings", storages={@Storage(file="$APP_CONFIG$/vsts_settings.xml")})
public class TeamServicesSettingsService
implements PersistentStateComponent<SettingsState> {
    private static final Logger logger = LoggerFactory.getLogger(TeamServicesSettingsService.class);
    private SettingsState state = null;
    private boolean serverContextsRestored = false;
    private boolean propertiesRestored = false;
    private static TeamServicesSettingsService DEFAULT_INSTANCE = new TeamServicesSettingsService();

    public static TeamServicesSettingsService getInstance() {
        TeamServicesSettingsService service = null;
        if (ApplicationManager.getApplication() != null) {
            service = (TeamServicesSettingsService)ServiceManager.getService(TeamServicesSettingsService.class);
        }
        if (service == null) {
            service = DEFAULT_INSTANCE;
        }
        return service;
    }

    @Nullable
    public SettingsState getState() {
        SettingsState saveState = new SettingsState();
        saveState.serverContexts = this.getServerContextStates();
        saveState.properties = this.getPropertyStates();
        return saveState;
    }

    public void loadState(SettingsState state) {
        this.state = state;
    }

    public List<ServerContext> restoreServerContexts() {
        ArrayList<ServerContext> serverContexts = new ArrayList<ServerContext>();
        if (this.state != null && this.state.serverContexts != null) {
            for (ServerContextState contextState : this.state.serverContexts) {
                String key = null;
                try {
                    key = ServerContext.getKey((String)contextState.uri);
                    AuthenticationInfo authenticationInfo = TeamServicesSecrets.load(key);
                    if (authenticationInfo == null) continue;
                    serverContexts.add(contextState.createBuilder().authentication(authenticationInfo).build());
                }
                catch (Throwable restoreThrowable) {
                    logger.warn("Failed to restore server context", restoreThrowable);
                    if (key == null) continue;
                    try {
                        TeamServicesSecrets.forget(key);
                    }
                    catch (Throwable cleanupThrowable) {
                        logger.warn("Failed to cleanup invalid server context");
                    }
                }
            }
        }
        this.serverContextsRestored = true;
        return serverContexts;
    }

    public Map<String, String> restoreProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.state != null && this.state.properties != null) {
            for (PropertyState ps : this.state.properties) {
                map.put(ps.name, ps.value);
            }
        }
        this.propertiesRestored = true;
        return map;
    }

    private ServerContextState[] getServerContextStates() {
        try {
            if (!this.serverContextsRestored && this.state != null) {
                return this.state.serverContexts;
            }
            Collection serverContexts = ServerContextManager.getInstance().getAllServerContexts();
            ArrayList<ServerContextState> contextStates = new ArrayList<ServerContextState>();
            for (ServerContext context : serverContexts) {
                contextStates.add(new ServerContextState(context));
            }
            return contextStates.toArray(new ServerContextState[contextStates.size()]);
        }
        catch (Throwable t) {
            logger.warn("getServerContextStates: Unexpected exception", t);
            return null;
        }
    }

    private PropertyState[] getPropertyStates() {
        try {
            if (!this.propertiesRestored && this.state != null) {
                return this.state.properties;
            }
            Map<String, String> map = PropertyServiceImpl.getInstance().getProperties();
            PropertyState[] states = new PropertyState[map.size()];
            int index = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                states[index++] = new PropertyState(entry.getKey(), entry.getValue());
            }
            return states;
        }
        catch (Throwable t) {
            logger.warn("getPropertyStates: Unexpected exception", t);
            return null;
        }
    }
}

