/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.setup;

import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxStartup {
    private static final Logger logger = LoggerFactory.getLogger(LinuxStartup.class);
    private static final String UPDATE_LOCAL_DESKTOP_DB_CMD = "update-desktop-database " + System.getProperty("user.home") + "/.local/share/applications/";
    private static final File USER_HOME = new File(System.getProperty("user.home"));
    private static final String VSOI_DESKTOP_FILE_PATH = ".local/share/applications/vsoi.desktop";
    private static final String SCRIPT_NAME = "vsts.sh";
    private static final String LINUX_DIR = "linux";

    public static void startup() {
        try {
            File script = new File(IdeaHelper.getResourcePath(LinuxStartup.class.getResource("/"), SCRIPT_NAME, LINUX_DIR));
            IdeaHelper.setExecutablePermissions(script);
            LinuxStartup.createDesktopFileAndUpdateDatabase(script, new File(USER_HOME, VSOI_DESKTOP_FILE_PATH));
        }
        catch (IOException e) {
            logger.warn("An IOException was caught while trying to run the Linux startup steps: {}", (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            logger.warn("An InterruptedException was caught while waiting for the database desktop to update: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.warn("An Exception was caught while trying to run the Linux startup steps", (Throwable)e);
        }
    }

    protected static File createDesktopFileAndUpdateDatabase(File scriptFile, File desktopFile) throws IOException, InterruptedException {
        String desktopFileContent = "[Desktop Entry]\nName=VSTS Protocol Handler\nComment=Custom protocol handler for the IntelliJ VSTS plugin\nExec=" + scriptFile.getAbsolutePath() + " %u\nIcon=\nTerminal=False\nType=Application\nX-MultipleArgs=True\nMimeType=x-scheme-handler/vsoi\nEncoding=UTF-8\nCategories=Network;Application;";
        if (LinuxStartup.isFileUpToDate(desktopFile, desktopFileContent)) {
            return desktopFile;
        }
        LinuxStartup.writeFile(desktopFile, desktopFileContent);
        try {
            Process process = Runtime.getRuntime().exec(UPDATE_LOCAL_DESKTOP_DB_CMD);
            process.waitFor();
            int exitCode = process.exitValue();
            if (exitCode != 0) {
                throw new RuntimeException("Non-zero exit code from " + UPDATE_LOCAL_DESKTOP_DB_CMD + ": " + exitCode);
            }
        }
        catch (Throwable t) {
            logger.warn("Unable to update local desktop database via " + UPDATE_LOCAL_DESKTOP_DB_CMD + ": " + t.getMessage(), t);
        }
        return desktopFile;
    }

    protected static void writeFile(File file, String content) throws IOException {
        file.getParentFile().mkdirs();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            writer.write(content);
        }
        finally {
            writer.close();
        }
    }

    protected static boolean isFileUpToDate(File file, String expectedContent) throws IOException {
        if (file.exists() && LinuxStartup.readFileAsString(file).equals(expectedContent)) {
            logger.info("file content is up-to-date: " + file);
            return true;
        }
        logger.info("file content needs updating: " + file);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readFileAsString(File filePath) throws IOException {
        DataInputStream dis = new DataInputStream(new FileInputStream(filePath));
        try {
            long len = filePath.length();
            byte[] bytes = new byte[(int)len];
            dis.readFully(bytes);
            String string = new String(bytes, "UTF-8");
            return string;
        }
        finally {
            dis.close();
        }
    }
}

