/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.setup;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.events.ServerEventManager;
import com.microsoft.alm.plugin.idea.common.utils.EventContextHelper;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectRepoEventManager {
    private static final Logger logger = LoggerFactory.getLogger(ProjectRepoEventManager.class);
    private static boolean repositoryChanging = false;
    private ProjectEventListener projectEventListener;

    public static ProjectRepoEventManager getInstance() {
        return Holder.INSTANCE;
    }

    protected ProjectRepoEventManager() {
        logger.info("ProjectRepoEventManager created");
    }

    public void startListening() {
        if (this.projectEventListener == null) {
            this.projectEventListener = new ProjectEventListener();
            ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)this.projectEventListener);
        }
    }

    private void triggerServerEvents(String sender, Project project, GitRepository repository) {
        ArgumentHelper.checkNotEmptyString((String)sender, (String)"sender");
        ArgumentHelper.checkNotNull((Object)project, (String)"project");
        Map<String, Object> context = EventContextHelper.createContext(sender);
        EventContextHelper.setProject(context, project);
        if (repository != null) {
            EventContextHelper.setRepository(context, repository);
        }
        ServerEventManager.getInstance().triggerAllEvents(context);
    }

    private static class ProjectEventListener
    implements ProjectManagerListener {
        private ProjectEventListener() {
        }

        public void projectOpened(Project project) {
            ProjectRepoEventManager.getInstance().triggerServerEvents("projectOpened", project, null);
            this.subscribeToRepoChangeEvents(project);
        }

        public boolean canCloseProject(Project project) {
            return true;
        }

        public void projectClosed(Project project) {
        }

        public void projectClosing(Project project) {
            ProjectRepoEventManager.getInstance().triggerServerEvents("projectClosing", project, null);
        }

        private void subscribeToRepoChangeEvents(final @NotNull Project project) {
            if (project == null) {
                ProjectEventListener.$$$reportNull$$$0(0);
            }
            project.getMessageBus().connect().subscribe(GitRepository.GIT_REPO_CHANGE, (Object)new GitRepositoryChangeListener(){

                public void repositoryChanged(@NotNull GitRepository repository) {
                    if (repository == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (repositoryChanging) {
                        logger.info("Ignoring repository changed event since we are already in the middle of a change.");
                    } else {
                        try {
                            repositoryChanging = true;
                            logger.info("repository changed");
                            ProjectRepoEventManager.getInstance().triggerServerEvents("repoChanged", project, repository);
                        }
                        finally {
                            repositoryChanging = false;
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/microsoft/alm/plugin/idea/common/setup/ProjectRepoEventManager$ProjectEventListener$1", "repositoryChanged"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/microsoft/alm/plugin/idea/common/setup/ProjectRepoEventManager$ProjectEventListener", "subscribeToRepoChangeEvents"));
        }
    }

    private static class Holder {
        private static final ProjectRepoEventManager INSTANCE = new ProjectRepoEventManager();

        private Holder() {
        }
    }
}

