/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.starters;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplicationStarterBase
extends ApplicationStarterEx {
    private final Logger logger = LoggerFactory.getLogger(ApplicationStarterBase.class);
    public static final String VSTS_COMMAND = "vsts";
    public final String URI_PREFIX = "vsoi://";
    private static final String ACTION_NAME = "ProtocolHandler";

    public abstract String getUsageMessage();

    protected abstract void processCommand(List<String> var1) throws RuntimeException;

    protected abstract void processUri(String var1) throws RuntimeException, UnsupportedEncodingException;

    public String getCommandName() {
        return VSTS_COMMAND;
    }

    public boolean isHeadless() {
        return false;
    }

    private static void saveAll() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ApplicationManager.getApplication().saveSettings();
    }

    protected boolean checkArguments(String[] args) {
        if (args.length < 2) {
            this.logger.error("VSTS failed due to lack of commands. Please specify the command that you want VSTS to execute");
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((String)VSTS_COMMAND, (String)args[0])) {
            this.logger.error("VSTS checkout failed due to the incorrect command being used. Expected \"vsts\" but found \"{}\".", (Object)args[0]);
            return false;
        }
        return true;
    }

    public void premain(String[] args) {
        if (!this.checkArguments(args)) {
            System.err.println(this.getUsageMessage());
            System.exit(1);
        }
    }

    public void main(String[] args) {
        this.logger.debug("Args passed to VSTS to process: {}", (Object)Arrays.toString(args));
        try {
            if (StringUtils.startsWithIgnoreCase((String)args[1], (String)"vsoi://")) {
                this.processUri(args[1].replaceFirst("vsoi://", ""));
            } else {
                ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
                argsList.remove(0);
                this.processCommand(argsList);
            }
        }
        catch (Exception e) {
            this.logger.error(TfPluginBundle.message("Checkout.Errors.Unexpected", e.getMessage()));
            ApplicationStarterBase.saveAll();
            System.exit(1);
        }
        catch (Throwable t) {
            this.logger.error(TfPluginBundle.message("Checkout.Errors.Unexpected", t.getMessage()));
            ApplicationStarterBase.saveAll();
            System.exit(2);
        }
        ApplicationStarterBase.saveAll();
    }

    public boolean canProcessExternalCommandLine() {
        return true;
    }
}

