/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.statusBar;

import com.intellij.openapi.ui.JBPopupMenu;
import com.microsoft.alm.plugin.idea.common.resources.Icons;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.statusBar.BuildStatusModel;
import com.microsoft.alm.plugin.idea.common.statusBar.StatusBarManager;
import com.microsoft.alm.plugin.idea.common.ui.common.FeedbackAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class BuildPopup
extends JBPopupMenu {
    private final BuildStatusModel model;

    public BuildPopup(BuildStatusModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model");
        }
        this.model = model;
        this.addBuildMenus();
    }

    private void addBuildMenus() {
        if (this.model.isSignedIn()) {
            this.addBuildItems();
            this.addQueueBuildItem();
            this.addRefreshItem();
        } else {
            this.addSignInItem();
        }
        this.addFeedbackSubMenu();
    }

    private void addBuildItems() {
        for (int i = 0; i < this.model.getBuildCount(); ++i) {
            final URI url = this.model.getBuildURI(i);
            JMenuItem item = new JMenuItem(TfPluginBundle.message("StatusBar.Build.Popup.ViewDetails", this.model.getBuildBranch(i)), this.model.getBuildSuccess(i) ? Icons.BUILD_STATUS_SUCCEEDED : Icons.BUILD_STATUS_FAILED);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (url != null) {
                        BuildPopup.this.model.gotoLink(url.toString());
                    }
                }
            });
            this.add(item);
        }
        if (this.getComponentCount() > 0) {
            this.addSeparator();
        }
    }

    private void addRefreshItem() {
        JMenuItem refreshItem = new JMenuItem(TfPluginBundle.message("StatusBar.Build.Popup.Refresh", new Object[0]));
        refreshItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusBarManager.updateStatusBar(BuildPopup.this.model.getProject(), false);
            }
        });
        this.add(refreshItem);
    }

    private void addSignInItem() {
        JMenuItem signInItem = new JMenuItem(TfPluginBundle.message("StatusBar.Build.Popup.SignIn", new Object[0]), Icons.VSLogoSmall);
        signInItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusBarManager.updateStatusBar(BuildPopup.this.model.getProject(), true);
            }
        });
        this.add(signInItem);
    }

    private void addFeedbackSubMenu() {
        this.addSeparator();
        FeedbackAction feedbackAction = new FeedbackAction(this.model.getProject(), ((Object)((Object)this)).getClass().getName());
        JMenu subMenu = feedbackAction.getSubMenu();
        this.add(subMenu);
    }

    private void addQueueBuildItem() {
        String menuText;
        URI url;
        if (this.model.getBuildCount() > 0) {
            url = this.model.getQueueBuildURI(this.model.getBuildCount() - 1);
            menuText = TfPluginBundle.message("StatusBar.Build.Popup.QueueBuild", new Object[0]);
        } else {
            url = this.model.getBuildsPageURI();
            menuText = TfPluginBundle.message("StatusBar.Build.Popup.ViewBuildsPage", new Object[0]);
        }
        JMenuItem queueBuildItem = new JMenuItem(menuText);
        queueBuildItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BuildPopup.this.model.gotoLink(url.toString());
            }
        });
        this.add(queueBuildItem);
    }
}

