/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.statusBar;

import com.intellij.openapi.project.Project;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.authentication.AuthHelper;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.AbstractModel;
import com.microsoft.alm.plugin.idea.common.utils.DateHelper;
import com.microsoft.alm.plugin.operations.BuildStatusLookupOperation;
import java.net.URI;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class BuildStatusModel
extends AbstractModel {
    private final Project project;
    private final boolean hasBuilds;
    private final boolean signedIn;
    private final boolean successful;
    private final String description;
    private final BuildStatusLookupOperation.BuildStatusResults operationResults;

    public static BuildStatusModel create(@NotNull Project project, @NotNull BuildStatusLookupOperation.BuildStatusResults results) {
        boolean signedIn;
        if (project == null) {
            BuildStatusModel.$$$reportNull$$$0(0);
        }
        if (results == null) {
            BuildStatusModel.$$$reportNull$$$0(1);
        }
        boolean bl = signedIn = results.getContext() != null;
        BuildStatusModel model = results.hasError() ? (AuthHelper.isNotAuthorizedError((Throwable)results.getError()) ? new BuildStatusModel(project, false, TfPluginBundle.message("StatusBar.Build.Error.Auth", new Object[0]), results) : new BuildStatusModel(project, signedIn, TfPluginBundle.message("StatusBar.Build.Error", results.getError().getMessage()), results)) : (results.isBuildFound() ? new BuildStatusModel(project, results.getBuildForDisplay().isSuccessful(), results.getBuildForDisplay().getBuildName(), results.getBuildForDisplay().getFinishTime(), results) : (signedIn ? new BuildStatusModel(project, true, TfPluginBundle.message("StatusBar.Build.NoBuildsFound", new Object[0]), results) : new BuildStatusModel(project, false, TfPluginBundle.message("StatusBar.Build.UnknownStatus", new Object[0]), results)));
        return model;
    }

    private BuildStatusModel(Project project, boolean signedIn, String description, BuildStatusLookupOperation.BuildStatusResults operationResults) {
        this.project = project;
        this.signedIn = signedIn;
        this.hasBuilds = false;
        this.successful = false;
        this.operationResults = operationResults;
        this.description = description;
    }

    private BuildStatusModel(Project project, boolean successful, String buildName, Date finishTime, BuildStatusLookupOperation.BuildStatusResults operationResults) {
        this.project = project;
        this.signedIn = true;
        this.hasBuilds = true;
        this.successful = successful;
        this.operationResults = operationResults;
        this.description = successful ? TfPluginBundle.message("StatusBar.Build.BuildSucceeded", buildName, DateHelper.getFriendlyDateTimeString(finishTime)) : TfPluginBundle.message("StatusBar.Build.BuildFailed", buildName, DateHelper.getFriendlyDateTimeString(finishTime));
    }

    public Project getProject() {
        return this.project;
    }

    public boolean hasStatusInformation() {
        return this.signedIn && this.hasBuilds;
    }

    public boolean isSignedIn() {
        return this.signedIn;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public String getDescription() {
        return this.description;
    }

    public int getBuildCount() {
        return this.hasStatusInformation() ? this.operationResults.getBuilds().size() : 0;
    }

    public boolean getBuildSuccess(int index) {
        return ((BuildStatusLookupOperation.BuildStatusRecord)this.operationResults.getBuilds().get(index)).isSuccessful();
    }

    public String getBuildBranch(int index) {
        return ((BuildStatusLookupOperation.BuildStatusRecord)this.operationResults.getBuilds().get(index)).getBranch();
    }

    public URI getBuildURI(int index) {
        if (this.operationResults.getContext() != null && this.operationResults.getContext().getTeamProjectURI() != null) {
            return UrlHelper.getBuildURI((URI)this.operationResults.getContext().getTeamProjectURI(), (int)((BuildStatusLookupOperation.BuildStatusRecord)this.operationResults.getBuilds().get(index)).getBuildId());
        }
        return null;
    }

    public URI getQueueBuildURI(int index) {
        if (this.operationResults.getContext() != null && this.operationResults.getContext().getTeamProjectCollectionReference() != null && this.operationResults.getContext().getTeamProjectReference() != null) {
            return UrlHelper.getQueueBuildURI((URI)this.operationResults.getContext().getServerUri(), (String)this.operationResults.getContext().getTeamProjectCollectionReference().getId().toString(), (String)this.operationResults.getContext().getTeamProjectReference().getName(), (int)((BuildStatusLookupOperation.BuildStatusRecord)this.operationResults.getBuilds().get(index)).getDefinitionId());
        }
        return null;
    }

    public URI getBuildsPageURI() {
        if (this.operationResults.getContext() != null && this.operationResults.getContext().getTeamProjectURI() != null) {
            return UrlHelper.getBuildsPageURI((URI)this.operationResults.getContext().getTeamProjectURI());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "results";
                break;
            }
        }
        objectArray[1] = "com/microsoft/alm/plugin/idea/common/statusBar/BuildStatusModel";
        objectArray[2] = "create";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

