/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.checkout;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextTableModel;
import com.microsoft.alm.plugin.idea.common.ui.common.SwingHelper;
import com.microsoft.alm.plugin.idea.common.ui.common.TableFocusListener;
import com.microsoft.alm.plugin.idea.common.ui.common.TableModelSelectionConverter;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.BasicForm;
import com.microsoft.alm.plugin.idea.common.ui.controls.BusySpinnerPanel;
import com.microsoft.alm.plugin.idea.common.ui.controls.HelpPanel;
import com.microsoft.alm.plugin.idea.common.ui.controls.HintTextFieldUI;
import com.microsoft.alm.plugin.idea.common.ui.controls.UserAccountPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableRowSorter;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NonNls;

public class CheckoutForm
implements BasicForm {
    private JTextField repositoryFilter;
    private JTable repositoryTable;
    private JTextField directoryName;
    private JPanel contentPanel;
    private UserAccountPanel userAccountPanel;
    private TextFieldWithBrowseButton parentDirectory;
    private JButton refreshButton;
    private BusySpinnerPanel busySpinner;
    private JScrollPane repositoryTableScrollPane;
    private HelpPanel helpPanel;
    private JCheckBox advancedCheckBox;
    private boolean initialized = false;
    private RepositoryContext.Type repositoryType;
    private Timer timer;
    @NonNls
    public static final String CMD_REPO_FILTER_CHANGED = "repositoryFilterChanged";
    @NonNls
    public static final String CMD_REFRESH = "refresh";
    @NonNls
    public static final String CMD_GOTO_TFS = "gotoTFS";
    @NonNls
    public static final String CMD_GOTO_SPS_PROFILE = "gotoSPSProfile";

    public CheckoutForm(boolean vsoSelected, RepositoryContext.Type repositoryType) {
        this.repositoryType = repositoryType;
        this.$$$setupUI$$$();
        this.userAccountPanel.setWindowsAccount(!vsoSelected);
    }

    @Override
    public JPanel getContentPanel() {
        this.ensureInitialized();
        return this.contentPanel;
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            this.repositoryFilter.setActionCommand(CMD_REPO_FILTER_CHANGED);
            this.refreshButton.setActionCommand(CMD_REFRESH);
            SwingHelper.scaleTableRowHeight(this.repositoryTable);
            SwingHelper.fixTabKeys(this.repositoryTable);
            this.repositoryTable.addFocusListener(new TableFocusListener(this.repositoryTable));
            this.helpPanel.addPopupCommand(TfPluginBundle.message("VsoLookupHelp.EnterUrl", new Object[0]), CMD_GOTO_TFS);
            this.helpPanel.addPopupCommand(TfPluginBundle.message("VsoLookupHelp.ViewAccounts", new Object[0]), CMD_GOTO_SPS_PROFILE);
            this.helpPanel.setVisible(false);
            this.repositoryFilter.setUI(new HintTextFieldUI(TfPluginBundle.message("CheckoutDialog.FilterHint", new Object[0])));
            this.parentDirectory.getInsets().right = 0;
            this.parentDirectory.addBrowseFolderListener(TfPluginBundle.message("CheckoutDialog.ParentFolder.DialogTitle", new Object[0]), null, null, new FileChooserDescriptor(false, true, false, false, false, false));
            int refreshButtonHeight = (int)this.refreshButton.getMinimumSize().getHeight();
            Dimension size = new Dimension(refreshButtonHeight, refreshButtonHeight);
            this.refreshButton.setMinimumSize(size);
            this.refreshButton.setPreferredSize(size);
            this.busySpinner.setMinimumSize(size);
            this.busySpinner.setPreferredSize(size);
            this.repositoryFilter.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.onFilterChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.onFilterChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.onFilterChanged();
                }

                private void onFilterChanged() {
                    if (CheckoutForm.this.timer.isRunning()) {
                        CheckoutForm.this.timer.restart();
                    } else {
                        CheckoutForm.this.timer.start();
                    }
                }
            });
            this.repositoryTableScrollPane.setMinimumSize(new Dimension(JBUI.scale((int)200), JBUI.scale((int)70)));
            this.advancedCheckBox.setSelected(false);
            if (this.repositoryType == RepositoryContext.Type.TFVC) {
                this.advancedCheckBox.setVisible(true);
                this.advancedCheckBox.setText(TfPluginBundle.message("CheckoutDialog.Tfvc.Advanced", new Object[0]));
            } else {
                this.advancedCheckBox.setVisible(false);
            }
            this.initialized = true;
        }
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.userAccountPanel.addActionListener(listener);
        this.timer.addActionListener(listener);
        this.refreshButton.addActionListener(listener);
        this.helpPanel.addActionListener(listener);
    }

    public void setRepositoryFilter(String filter) {
        this.repositoryFilter.setText(filter);
    }

    public String getRepositoryFilter() {
        return this.repositoryFilter.getText();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.repositoryFilter;
    }

    public void setRepositoryTable(ServerContextTableModel tableModel, ListSelectionModel selectionModel) {
        this.repositoryTable.setModel(tableModel);
        this.repositoryTable.setSelectionModel(selectionModel);
        TableRowSorter<ServerContextTableModel> sorter = new TableRowSorter<ServerContextTableModel>(tableModel);
        this.repositoryTable.setRowSorter(sorter);
        tableModel.setSelectionConverter(new TableModelSelectionConverter(){

            @Override
            public int convertRowIndexToModel(int viewRowIndex) {
                if (viewRowIndex >= 0) {
                    return CheckoutForm.this.repositoryTable.convertRowIndexToModel(viewRowIndex);
                }
                return viewRowIndex;
            }
        });
    }

    public void setParentDirectory(String path) {
        this.parentDirectory.setText(path);
    }

    public String getParentDirectory() {
        return StringUtils.trim((String)this.parentDirectory.getText());
    }

    public JComponent getParentDirectoryComponent() {
        return this.parentDirectory.getTextField();
    }

    public void setDirectoryName(String name) {
        this.directoryName.setText(name);
    }

    public String getDirectoryName() {
        return StringUtils.trim((String)this.directoryName.getText());
    }

    public JComponent getDirectoryNameComponent() {
        return this.directoryName;
    }

    public void setUserName(String name) {
        this.userAccountPanel.setUserName(name);
    }

    public void setServerName(String name) {
        this.userAccountPanel.setServerName(name);
        if (!this.userAccountPanel.isWindowsAccount() || UrlHelper.isTeamServicesUrl((String)name)) {
            this.helpPanel.setVisible(true);
        } else {
            this.helpPanel.setVisible(false);
        }
    }

    public void setLoading(boolean loading) {
        if (loading) {
            this.refreshButton.setVisible(false);
            this.busySpinner.start(true);
        } else {
            this.busySpinner.stop(true);
            this.refreshButton.setVisible(true);
        }
    }

    public boolean isAdvanced() {
        return this.advancedCheckBox.isSelected();
    }

    public void setAdvanced(boolean advanced) {
        this.advancedCheckBox.setSelected(advanced);
    }

    private void createUIComponents() {
        this.userAccountPanel = new UserAccountPanel();
        this.refreshButton = new JButton(AllIcons.Actions.Refresh);
        this.timer = new Timer(400, null);
        this.timer.setInitialDelay(400);
        this.timer.setActionCommand(CMD_REPO_FILTER_CHANGED);
        this.timer.setRepeats(false);
    }

    @VisibleForTesting
    UserAccountPanel getUserAccountPanel() {
        return this.userAccountPanel;
    }

    @VisibleForTesting
    BusySpinnerPanel getBusySpinner() {
        return this.busySpinner;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        BusySpinnerPanel busySpinnerPanel;
        JCheckBox jCheckBox;
        HelpPanel helpPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTable jTable;
        JScrollPane jScrollPane;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.createUIComponents();
        this.contentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(10, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setName("");
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("VsoCheckoutForm.SelectRepository"));
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.repositoryFilter = jTextField2 = new JTextField();
        jTextField2.setName("");
        jPanel.add((Component)jTextField2, new GridConstraints(2, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("VsoCheckoutForm.ParentDirectory"));
        jPanel.add((Component)jLabel2, new GridConstraints(5, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("VsoCheckoutForm.DirectoryName"));
        jPanel.add((Component)jLabel3, new GridConstraints(7, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.directoryName = jTextField = new JTextField();
        jTextField.setName("");
        jPanel.add((Component)jTextField, new GridConstraints(8, 0, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        UserAccountPanel userAccountPanel = this.userAccountPanel;
        jPanel.add((Component)userAccountPanel, new GridConstraints(0, 0, 1, 3, 4, 0, 3, 3, null, null, null));
        this.repositoryTableScrollPane = jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(3, 0, 1, 3, 0, 3, 7, 7, null, null, null));
        this.repositoryTable = jTable = new JTable();
        jTable.setFillsViewportHeight(true);
        jTable.setName("");
        jTable.setShowHorizontalLines(false);
        jTable.setShowVerticalLines(false);
        jScrollPane.setViewportView(jTable);
        this.parentDirectory = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(6, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        this.helpPanel = helpPanel = new HelpPanel();
        helpPanel.setHelpText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("VsoLookupHelp.helpText"));
        helpPanel.setPopupText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("VsoLookupHelp.Instructions"));
        jPanel.add((Component)helpPanel, new GridConstraints(4, 0, 1, 3, 4, 0, 3, 3, null, null, null));
        this.advancedCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("example text");
        jPanel.add((Component)jCheckBox, new GridConstraints(9, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.busySpinner = busySpinnerPanel = new BusySpinnerPanel();
        jPanel.add((Component)busySpinnerPanel, new GridConstraints(2, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JButton jButton = this.refreshButton;
        jButton.setToolTipText(ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CheckoutDialog.RefreshButton.ToolTip"));
        jPanel.add((Component)jButton, new GridConstraints(2, 2, 1, 1, 0, 1, 1, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

