/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.common;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.authentication.AuthenticationListener;
import com.microsoft.alm.plugin.authentication.AuthenticationProvider;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextBuilder;
import com.microsoft.alm.plugin.exceptions.ProfileDoesNotExistException;
import com.microsoft.alm.plugin.exceptions.TeamServicesException;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.services.LocalizationServiceImpl;
import com.microsoft.alm.plugin.idea.common.ui.common.LoginPageModel;
import com.microsoft.alm.plugin.idea.common.ui.common.ModelValidationInfo;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextLookupListener;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextLookupPageModel;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.operations.AccountLookupOperation;
import com.microsoft.alm.plugin.operations.Operation;
import com.microsoft.alm.plugin.operations.OperationFactory;
import com.microsoft.alm.plugin.operations.ServerContextLookupOperation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupHelper {
    private static final Logger logger = LoggerFactory.getLogger(LookupHelper.class);

    public static void authenticateAndLoadTfsContexts(final LoginPageModel loginPageModel, final ServerContextLookupPageModel lookupPageModel, final AuthenticationProvider authenticationProvider, final ServerContextLookupListener lookupListener, final ServerContextLookupOperation.ContextScope scope) {
        loginPageModel.clearErrors();
        String serverName = loginPageModel.getServerName();
        if (StringUtils.isEmpty((String)serverName)) {
            loginPageModel.addError(ModelValidationInfo.createWithResource("serverName", "LoginForm.TFS.Errors.NoServerName", new Object[0]));
            loginPageModel.setConnected(false);
            return;
        }
        if (!UrlHelper.isValidUrl((String)serverName)) {
            loginPageModel.addError(ModelValidationInfo.createWithResource("serverName", "LoginForm.TFS.Errors.InvalidServerUrl", serverName));
            loginPageModel.setConnected(false);
            return;
        }
        if (authenticationProvider.isAuthenticated(serverName)) {
            LookupHelper.loadTfsContexts(loginPageModel, lookupPageModel, authenticationProvider, lookupListener, scope);
        } else {
            authenticationProvider.authenticateAsync(serverName, new AuthenticationListener(){

                public void authenticating() {
                    IdeaHelper.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            loginPageModel.setAuthenticating(true);
                        }
                    });
                }

                public void authenticated(AuthenticationInfo authenticationInfo, final Throwable throwable) {
                    IdeaHelper.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            loginPageModel.setAuthenticating(false);
                            if (throwable != null) {
                                logger.warn("Connecting to TFS server failed", throwable);
                                if (LookupHelper.handleProfileDoesNotExist(throwable, loginPageModel)) {
                                    return;
                                }
                                if (throwable instanceof TeamServicesException) {
                                    loginPageModel.addError(ModelValidationInfo.createWithMessage(LocalizationServiceImpl.getInstance().getExceptionMessage(throwable)));
                                } else {
                                    loginPageModel.addError(ModelValidationInfo.createWithResource("serverName", "LoginForm.Errors.TFS.ConnectFailed", loginPageModel.getServerName()));
                                }
                                loginPageModel.signOut();
                            } else {
                                LookupHelper.loadTfsContexts(loginPageModel, lookupPageModel, authenticationProvider, lookupListener, scope);
                            }
                        }
                    });
                }
            });
        }
    }

    public static void loadTfsContexts(LoginPageModel loginPageModel, ServerContextLookupPageModel lookupPageModel, AuthenticationProvider authenticationProvider, ServerContextLookupListener lookupListener, ServerContextLookupOperation.ContextScope scope) {
        if (!authenticationProvider.isAuthenticated(loginPageModel.getServerName())) {
            loginPageModel.addError(ModelValidationInfo.createWithResource("serverName", "LoginForm.Errors.TFS.ConnectFailed", loginPageModel.getServerName()));
            loginPageModel.signOut();
            return;
        }
        loginPageModel.setConnected(true);
        lookupPageModel.setLoading(true);
        loginPageModel.setUserName(authenticationProvider.getAuthenticationInfo(loginPageModel.getServerName()).getUserNameForDisplay());
        lookupPageModel.clearContexts();
        URI serverUrl = UrlHelper.createUri((String)loginPageModel.getServerName());
        ServerContext context = new ServerContextBuilder().type(ServerContext.Type.TFS).uri(serverUrl).authentication(authenticationProvider.getAuthenticationInfo(loginPageModel.getServerName())).build();
        lookupListener.loadContexts(Collections.singletonList(context), scope);
    }

    public static void authenticateAndLoadVsoContexts(final LoginPageModel loginPageModel, final ServerContextLookupPageModel lookupPageModel, final AuthenticationProvider authenticationProvider, final ServerContextLookupListener lookupListener, final ServerContextLookupOperation.ContextScope scope) {
        loginPageModel.clearErrors();
        String serverUri = LookupHelper.getVsspsUrlFromDisplayName(loginPageModel.getServerName());
        if (authenticationProvider.isAuthenticated(serverUri)) {
            LookupHelper.loadVsoContexts(loginPageModel, lookupPageModel, authenticationProvider, lookupListener, scope);
        } else {
            String vsoServerUrl = LookupHelper.isValidVsoURL(loginPageModel.getServerName()) ? UrlHelper.getHttpsUrlFromHttpUrl((String)loginPageModel.getServerName()) : "https://app.vssps.visualstudio.com";
            authenticationProvider.authenticateAsync(vsoServerUrl, new AuthenticationListener(){

                public void authenticating() {
                    IdeaHelper.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            loginPageModel.setAuthenticating(true);
                        }
                    });
                }

                public void authenticated(AuthenticationInfo authenticationInfo, final Throwable throwable) {
                    IdeaHelper.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            loginPageModel.setAuthenticating(false);
                            if (throwable != null) {
                                logger.warn("Authenticating with Team Services failed", throwable);
                                if (LookupHelper.handleProfileDoesNotExist(throwable, loginPageModel)) {
                                    return;
                                }
                            }
                            LookupHelper.loadVsoContexts(loginPageModel, lookupPageModel, authenticationProvider, lookupListener, scope);
                        }
                    });
                }
            });
        }
    }

    public static boolean handleProfileDoesNotExist(Throwable throwable, LoginPageModel loginPageModel) {
        if (throwable instanceof ProfileDoesNotExistException) {
            logger.info("Exception ProfileDoesNotExistException found and being handled.");
            String url = "https://go.microsoft.com/fwlink/?LinkId=800292";
            String error = String.format("<html>%s<br>%s<br><a href=\"%s\">%s</a></html>", LocalizationServiceImpl.getInstance().getExceptionMessage(throwable), TfPluginBundle.message("VSO.NoProfileError.Help", new Object[0]), "https://go.microsoft.com/fwlink/?LinkId=800292", "https://go.microsoft.com/fwlink/?LinkId=800292");
            Project project = ProjectManager.getInstance().getDefaultProject();
            IdeaHelper.showErrorDialog(project, error);
            loginPageModel.addError(ModelValidationInfo.createWithMessage(error));
            loginPageModel.signOut();
            return true;
        }
        return false;
    }

    public static void loadVsoContexts(final LoginPageModel loginPageModel, ServerContextLookupPageModel lookupPageModel, AuthenticationProvider authenticationProvider, final ServerContextLookupListener lookupListener, final ServerContextLookupOperation.ContextScope scope) {
        String serverUri = LookupHelper.getVsspsUrlFromDisplayName(loginPageModel.getServerName());
        if (!authenticationProvider.isAuthenticated(serverUri)) {
            loginPageModel.addError(ModelValidationInfo.createWithResource("LoginForm.Errors.VSO.SigninFailed", new Object[0]));
            loginPageModel.signOut();
            return;
        }
        loginPageModel.setConnected(true);
        lookupPageModel.setLoading(true);
        loginPageModel.setUserName(authenticationProvider.getAuthenticationInfo(serverUri).getUserNameForDisplay());
        lookupPageModel.clearContexts();
        if (LookupHelper.isValidVsoURL(loginPageModel.getServerName())) {
            ServerContext vsoAccountContext = new ServerContextBuilder().uri(UrlHelper.getHttpsUrlFromHttpUrl((String)loginPageModel.getServerName())).type(ServerContext.Type.VSO).authentication(authenticationProvider.getAuthenticationInfo(loginPageModel.getServerName())).build();
            ArrayList<ServerContext> vsoContexts = new ArrayList<ServerContext>();
            vsoContexts.add(vsoAccountContext);
            lookupListener.loadContexts(vsoContexts, scope);
        } else {
            final AccountLookupOperation accountLookupOperation = OperationFactory.createAccountLookupOperation();
            accountLookupOperation.addListener(new Operation.Listener(){

                public void notifyLookupStarted() {
                }

                public void notifyLookupCompleted() {
                }

                public void notifyLookupResults(Operation.Results results) {
                    ModelValidationInfo validationInfo;
                    if (results.hasError()) {
                        validationInfo = ModelValidationInfo.createWithMessage(LocalizationServiceImpl.getInstance().getExceptionMessage(results.getError()));
                    } else if (results.isCancelled()) {
                        validationInfo = ModelValidationInfo.createWithResource("Operation.Lookup.Canceled", new Object[0]);
                    } else {
                        validationInfo = ModelValidationInfo.NO_ERRORS;
                        lookupListener.loadContexts(accountLookupOperation.castResults(results).getServerContexts(), scope);
                    }
                    if (validationInfo != ModelValidationInfo.NO_ERRORS) {
                        IdeaHelper.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                loginPageModel.addError(validationInfo);
                                loginPageModel.signOut();
                            }
                        });
                    }
                }
            });
            accountLookupOperation.doWorkAsync(Operation.EMPTY_INPUTS);
        }
    }

    private static boolean isValidVsoURL(String serverName) {
        return !StringUtils.equals((String)serverName, (String)TfPluginBundle.message("UserAccountPanel.VSO.ServerName", new Object[0])) && UrlHelper.isValidUrl((String)serverName) && UrlHelper.isVSO((URI)UrlHelper.createUri((String)serverName)) && UrlHelper.getHttpsUrlFromHttpUrl((String)serverName) != null;
    }

    public static String getVsspsUrlFromDisplayName(String displayName) {
        return StringUtils.equals((String)TfPluginBundle.message("UserAccountPanel.VSO.ServerName", new Object[0]), (String)displayName) ? "https://app.vssps.visualstudio.com" : displayName;
    }
}

