/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.common;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.exceptions.TeamServicesException;
import com.microsoft.alm.plugin.idea.common.services.LocalizationServiceImpl;
import com.microsoft.alm.plugin.idea.common.ui.common.ModelValidationInfo;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextLookupPageModel;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.operations.Operation;
import com.microsoft.alm.plugin.operations.ServerContextLookupOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerContextLookupListener
implements Operation.Listener {
    private static final Logger logger = LoggerFactory.getLogger(ServerContextLookupListener.class);
    private final ServerContextLookupPageModel pageModel;
    private ServerContextLookupOperation activeOperation;

    public ServerContextLookupListener(ServerContextLookupPageModel pageModel) {
        ArgumentHelper.checkNotNull((Object)pageModel, (String)"pageModel");
        this.pageModel = pageModel;
    }

    public void loadContexts(List<ServerContext> contexts, ServerContextLookupOperation.ContextScope resultScope) {
        logger.info(String.format("loadContexts activeOperation with %s contexts and a scope of %s", contexts != null ? Integer.valueOf(contexts.size()) : "n/a", resultScope != null ? resultScope.name() : "n/a"));
        ServerContextLookupOperation activeOperation = new ServerContextLookupOperation(contexts, resultScope);
        this.loadContexts(activeOperation);
    }

    public void loadContexts(ServerContextLookupOperation activeOperation) {
        logger.info(String.format("loadContexts terminateActiveOperation in state %s", activeOperation.getState().name()));
        ArgumentHelper.checkNotNull((Object)activeOperation, (String)"activeOperation");
        this.terminateActiveOperation();
        this.activeOperation = activeOperation;
        this.activeOperation.addListener((Operation.Listener)this);
        this.activeOperation.doWorkAsync(Operation.EMPTY_INPUTS);
    }

    public void notifyLookupStarted() {
        logger.info("ServerContext lookup started");
        IdeaHelper.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                ServerContextLookupListener.this.pageModel.setLoading(true);
                ServerContextLookupListener.this.pageModel.clearContexts();
            }
        });
    }

    public void notifyLookupCompleted() {
        logger.info("ServerContext lookup completed");
        this.operationDone();
        IdeaHelper.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                ServerContextLookupListener.this.pageModel.setLoading(false);
            }
        });
    }

    public void notifyLookupResults(final Operation.Results results) {
        logger.info("ServerContext lookup results has error: " + results.hasError());
        final ServerContextLookupOperation.ServerContextLookupResults lookupResults = (ServerContextLookupOperation.ServerContextLookupResults)results;
        if (lookupResults.isCancelled()) {
            this.operationDone();
            IdeaHelper.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    ServerContextLookupListener.this.pageModel.addError(ModelValidationInfo.createWithResource("Operation.Lookup.Canceled", new Object[0]));
                    ServerContextLookupListener.this.pageModel.setLoading(false);
                }
            });
        } else {
            IdeaHelper.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    ServerContextLookupListener.this.pageModel.appendContexts(lookupResults.getServerContexts());
                    if (lookupResults.hasError()) {
                        if (lookupResults.getError() instanceof TeamServicesException) {
                            ServerContextLookupListener.this.pageModel.addError(ModelValidationInfo.createWithMessage(LocalizationServiceImpl.getInstance().getExceptionMessage(results.getError())));
                        } else {
                            ServerContextLookupListener.this.pageModel.addError(ModelValidationInfo.createWithResource("Operation.Lookup.Errors", new Object[0]));
                        }
                    }
                }
            });
        }
    }

    private void operationDone() {
        logger.info("ServerContext operation done");
        if (this.activeOperation != null) {
            this.activeOperation.removeListener((Operation.Listener)this);
            this.activeOperation = null;
        }
    }

    public void terminateActiveOperation() {
        logger.info("ServerContext operation terminated");
        if (this.activeOperation != null) {
            this.activeOperation.removeListener((Operation.Listener)this);
            this.activeOperation.cancel();
            this.activeOperation = null;
        }
    }
}

