/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.common;

import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.core.webapi.model.TeamProjectCollectionReference;
import com.microsoft.alm.core.webapi.model.TeamProjectReference;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.TableModelSelectionConverter;
import com.microsoft.alm.sourcecontrol.webapi.model.GitRepository;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import jersey.repackaged.com.google.common.base.Predicate;
import jersey.repackaged.com.google.common.collect.Collections2;
import jersey.repackaged.com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;

public class ServerContextTableModel
extends AbstractTableModel {
    public static final Column[] VSO_GIT_REPO_COLUMNS = new Column[]{Column.GIT_REPOSITORY, Column.PROJECT, Column.ACCOUNT};
    public static final Column[] TFS_GIT_REPO_COLUMNS = new Column[]{Column.GIT_REPOSITORY, Column.PROJECT, Column.COLLECTION};
    public static final Column[] VSO_TFVC_REPO_COLUMNS = new Column[]{Column.TFVC_REPOSITORY, Column.PROJECT, Column.ACCOUNT};
    public static final Column[] TFS_TFVC_REPO_COLUMNS = new Column[]{Column.TFVC_REPOSITORY, Column.PROJECT, Column.COLLECTION};
    public static final Column[] VSO_PROJECT_COLUMNS = new Column[]{Column.PROJECT, Column.ACCOUNT};
    public static final Column[] TFS_PROJECT_COLUMNS = new Column[]{Column.PROJECT, Column.COLLECTION};
    public static final Column[] GENERAL_COLUMNS = new Column[]{Column.GENERAL_REPOSITORY, Column.ACCOUNT_URL, Column.USER_NAME};
    private static final TableModelSelectionConverter DEFAULT_CONVERTER = new TableModelSelectionConverter(){

        @Override
        public int convertRowIndexToModel(int viewRowIndex) {
            return viewRowIndex;
        }
    };
    private ListSelectionModel selectionModel = new DefaultListSelectionModel();
    private List<ServerContext> rows = new ArrayList<ServerContext>(1000);
    private List<ServerContext> filteredRows = null;
    private String filter;
    private final Column[] columns;
    private TableModelSelectionConverter converter;

    public ServerContextTableModel(Column[] columns) {
        this(columns, 0);
    }

    public ServerContextTableModel(Column[] columns, int selectionType) {
        assert (columns != null);
        this.columns = (Column[])columns.clone();
        this.selectionModel.setSelectionMode(selectionType);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public ServerContext getServerContext(int rowIndex) {
        List<ServerContext> localRows = this.filteredRows != null ? this.filteredRows : this.rows;
        if (rowIndex >= 0 && rowIndex < localRows.size()) {
            return localRows.get(rowIndex);
        }
        return null;
    }

    public void addServerContexts(List<ServerContext> contexts) {
        ServerContext selectedContext = this.getSelectedContext();
        this.rows.addAll(contexts);
        Collections.sort(this.rows, new Comparator<ServerContext>(){

            @Override
            public int compare(ServerContext c1, ServerContext c2) {
                String name1 = ServerContextTableModel.this.getValueFor(c1, 0);
                String name2 = ServerContextTableModel.this.getValueFor(c2, 0);
                return String.CASE_INSENSITIVE_ORDER.compare(name1, name2);
            }
        });
        if (this.hasFilter()) {
            this.applyFilter();
        } else {
            super.fireTableDataChanged();
        }
        this.select(selectedContext);
    }

    public void setSelectionConverter(TableModelSelectionConverter converter) {
        this.converter = converter;
    }

    public TableModelSelectionConverter getSelectionConverter() {
        if (this.converter == null) {
            return DEFAULT_CONVERTER;
        }
        return this.converter;
    }

    public int getSelectedIndex() {
        int viewSelectedIndex = this.selectionModel.isSelectedIndex(this.selectionModel.getMinSelectionIndex()) ? this.selectionModel.getMinSelectionIndex() : this.selectionModel.getMaxSelectionIndex();
        int selectedIndex = this.getSelectionConverter().convertRowIndexToModel(viewSelectedIndex);
        return selectedIndex;
    }

    public List<Integer> getSelectedIndices() {
        ArrayList<Integer> indices = new ArrayList<Integer>(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getSelectionModel().isSelectedIndex(i)) continue;
            indices.add(i);
        }
        return indices;
    }

    public ServerContext getSelectedContext() {
        ServerContext selectedContext = this.getServerContext(this.getSelectedIndex());
        return selectedContext;
    }

    public List<ServerContext> getSelectedContexts() {
        List<Integer> indices = this.getSelectedIndices();
        ArrayList<ServerContext> contexts = new ArrayList<ServerContext>(indices.size());
        for (int index : indices) {
            contexts.add(this.getServerContext(index));
        }
        return contexts;
    }

    private void select(ServerContext context) {
        List<ServerContext> localRows = this.filteredRows != null ? this.filteredRows : this.rows;
        int index = localRows.indexOf(context);
        if (index >= 0) {
            this.selectionModel.setSelectionInterval(index, index);
        }
    }

    public void clearRows() {
        this.filteredRows = null;
        this.rows.clear();
        super.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.filteredRows != null) {
            return this.filteredRows.size();
        }
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ServerContext serverContext = this.getServerContext(rowIndex);
        return this.getValueFor(serverContext, columnIndex);
    }

    private String getValueFor(ServerContext serverContext, int columnIndex) {
        if (serverContext == null) {
            return "";
        }
        Column column = this.columns[columnIndex];
        switch (column) {
            case GIT_REPOSITORY: {
                GitRepository repository = serverContext.getGitRepository();
                return repository != null ? repository.getName() : "";
            }
            case TFVC_REPOSITORY: {
                TeamProjectReference teamProject = serverContext.getTeamProjectReference();
                return teamProject != null ? "$/" + teamProject.getName() : "";
            }
            case PROJECT: {
                TeamProjectReference teamProject = serverContext.getTeamProjectReference();
                return teamProject != null ? teamProject.getName() : "";
            }
            case COLLECTION: {
                TeamProjectCollectionReference collection = serverContext.getTeamProjectCollectionReference();
                return collection != null ? collection.getName() : "";
            }
            case ACCOUNT: {
                return UrlHelper.isOrganizationURI((URI)serverContext.getUri()) ? serverContext.getUri().getHost() + "/" + serverContext.getTeamProjectCollectionReference().getName() : serverContext.getUri().getHost();
            }
            case GENERAL_REPOSITORY: {
                if (serverContext.getGitRepository() != null) {
                    return serverContext.getGitRepository().getName();
                }
                TeamProjectReference teamProject = serverContext.getTeamProjectReference();
                return teamProject != null ? "$/" + teamProject.getName() : "";
            }
            case USER_NAME: {
                if (serverContext.getAuthenticationInfo() != null) {
                    return serverContext.getAuthenticationInfo().getUserNameForDisplay();
                }
                return "";
            }
            case ACCOUNT_URL: {
                return serverContext.getUri().toString();
            }
        }
        return "";
    }

    @Override
    public String getColumnName(int columnIndex) {
        Column column = this.columns[columnIndex];
        switch (column) {
            case GIT_REPOSITORY: 
            case TFVC_REPOSITORY: {
                return TfPluginBundle.message("ServerContextTable.RepoColumn", new Object[0]);
            }
            case PROJECT: {
                return TfPluginBundle.message("ServerContextTable.ProjectColumn", new Object[0]);
            }
            case COLLECTION: {
                return TfPluginBundle.message("ServerContextTable.CollectionColumn", new Object[0]);
            }
            case ACCOUNT: {
                return TfPluginBundle.message("ServerContextTable.AccountColumn", new Object[0]);
            }
            case GENERAL_REPOSITORY: {
                return TfPluginBundle.message("ServerContextTable.RepoColumn", new Object[0]);
            }
            case USER_NAME: {
                return TfPluginBundle.message("Settings.Config.Mgt.UserName", new Object[0]);
            }
            case ACCOUNT_URL: {
                return TfPluginBundle.message("Settings.Config.Mgt.RepoUrl", new Object[0]);
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    public boolean hasFilter() {
        return StringUtils.isNotEmpty((String)this.filter);
    }

    public void setFilter(String filter) {
        this.filter = filter;
        ServerContext selectedContext = this.getSelectedContext();
        this.applyFilter();
        this.select(selectedContext);
    }

    private void applyFilter() {
        this.filteredRows = !this.hasFilter() ? null : Lists.newArrayList((Iterable)Collections2.filter(this.rows, (Predicate)new Predicate<ServerContext>(){

            public boolean apply(ServerContext repositoryRow) {
                return ServerContextTableModel.this.rowContains(repositoryRow);
            }
        }));
        super.fireTableDataChanged();
    }

    private boolean rowContains(ServerContext repositoryRow) {
        for (int c = 0; c < this.columns.length; ++c) {
            if (!StringUtils.containsIgnoreCase((String)this.getValueFor(repositoryRow, c), (String)this.filter)) continue;
            return true;
        }
        return false;
    }

    public static enum Column {
        GIT_REPOSITORY,
        TFVC_REPOSITORY,
        PROJECT,
        COLLECTION,
        ACCOUNT,
        GENERAL_REPOSITORY,
        USER_NAME,
        ACCOUNT_URL;

    }
}

