/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.common;

import com.intellij.util.ui.JBUI;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class SwingHelper {
    public static void fixTabKeys(JComponent component) {
        HashSet<AWTKeyStroke> forward = new HashSet<AWTKeyStroke>(component.getFocusTraversalKeys(0));
        forward.add(KeyStroke.getKeyStroke("TAB"));
        component.setFocusTraversalKeys(0, forward);
        HashSet<AWTKeyStroke> backward = new HashSet<AWTKeyStroke>(component.getFocusTraversalKeys(1));
        backward.add(KeyStroke.getKeyStroke("shift TAB"));
        component.setFocusTraversalKeys(1, backward);
    }

    public static void setPreferredHeight(JComponent component, int height) {
        Dimension size = component.getPreferredSize();
        size.setSize(size.getWidth(), (double)JBUI.scale((int)height));
        component.setPreferredSize(size);
    }

    public static void copyFontAndMargins(JTextArea target, JComponent source) {
        Insets insets = source.getInsets();
        target.setFont(source.getFont());
        target.setMargin(insets);
    }

    public static void setMargin(JComponent component, int eachSide) {
        Insets insets = new Insets(eachSide, eachSide, eachSide, eachSide);
        SwingHelper.setMargin(component, insets);
    }

    public static void setMargin(JComponent component, Insets newMargin) {
        Border currentBorder = component.getBorder();
        EmptyBorder empty = new EmptyBorder(newMargin.top, newMargin.left, newMargin.bottom, newMargin.right);
        if (currentBorder == null || currentBorder instanceof EmptyBorder) {
            component.setBorder(empty);
        } else if (currentBorder instanceof CompoundBorder) {
            CompoundBorder current = (CompoundBorder)currentBorder;
            Border insideBorder = current.getInsideBorder();
            component.setBorder(new CompoundBorder(empty, insideBorder));
        } else {
            component.setBorder(new CompoundBorder(empty, currentBorder));
        }
    }

    public static void scaleTableRowHeight(JTable table) {
        if (table != null && table.getFont() != null) {
            table.setRowHeight(table.getFontMetrics(table.getFont()).getHeight() + JBUI.scale((int)1));
        }
    }

    public static void addToGridBag(JPanel panel, Component component, int x, int y) {
        SwingHelper.addToGridBag(panel, component, x, y, 1, 1, -1, -1);
    }

    public static void addToGridBag(JPanel panel, Component component, int x, int y, int spanX, int spanY) {
        SwingHelper.addToGridBag(panel, component, x, y, spanX, spanY, -1, -1);
    }

    public static void addToGridBag(JPanel panel, Component component, int x, int y, int spanX, int spanY, int topMargin, int rightMargin) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = x;
        c.gridy = y;
        c.gridwidth = spanX;
        c.gridheight = spanY;
        if (rightMargin >= 0) {
            c.insets.right = rightMargin;
        }
        if (topMargin != 0) {
            c.insets.top = topMargin;
        }
        c.anchor = 17;
        panel.add(component, c);
    }

    public static void setMaxCharLimit(JTextArea textField, int limit) {
        textField.setDocument(new MaxCharLimitDocument(limit));
    }

    private static class MaxCharLimitDocument
    extends PlainDocument {
        private final int maxCharLimit;

        MaxCharLimitDocument(int limit) {
            this.maxCharLimit = limit;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() + str.length() <= this.maxCharLimit) {
                super.insertString(offset, str, attr);
            }
        }
    }
}

