/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.common.tabs;

import com.microsoft.alm.plugin.events.ServerEvent;
import com.microsoft.alm.plugin.events.ServerEventListener;
import com.microsoft.alm.plugin.events.ServerEventManager;
import com.microsoft.alm.plugin.idea.common.ui.common.VcsTabStatus;
import com.microsoft.alm.plugin.idea.common.ui.common.tabs.Tab;
import com.microsoft.alm.plugin.idea.common.ui.common.tabs.TabController;
import com.microsoft.alm.plugin.idea.common.ui.common.tabs.TabModel;
import com.microsoft.alm.plugin.idea.common.utils.EventContextHelper;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class TabControllerImpl<T extends TabModel>
implements TabController,
Observer,
ActionListener {
    protected Tab tab;
    protected T model;

    public TabControllerImpl(@NotNull Tab tab, @NotNull T model, final ServerEvent[] eventFilters) {
        if (tab == null) {
            TabControllerImpl.$$$reportNull$$$0(0);
        }
        if (model == null) {
            TabControllerImpl.$$$reportNull$$$0(1);
        }
        this.tab = tab;
        this.model = model;
        tab.addActionListener(this);
        this.update(null, null);
        model.addObserver(this);
        model.loadData();
        ServerEventManager.getInstance().addListener(new ServerEventListener(){

            public void serverChanged(ServerEvent event, Map<String, Object> contextMap) {
                for (ServerEvent filter : eventFilters) {
                    if (filter != event) continue;
                    TabControllerImpl.this.handleServerChangedEvent(event, contextMap);
                    break;
                }
            }
        });
    }

    protected void handleServerChangedEvent(ServerEvent event, Map<String, Object> contextMap) {
        if (!this.model.getAutoRefresh() || EventContextHelper.isProjectClosing(contextMap)) {
            return;
        }
        IdeaHelper.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                TabControllerImpl.this.model.loadData(false);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateModel();
        this.performAction(e);
    }

    protected void performAction(ActionEvent e) {
        if ("createNewItemLink".equals(e.getActionCommand())) {
            this.model.createNewItem();
        } else if ("refresh".equals(e.getActionCommand())) {
            this.model.loadData();
            this.tab.refresh(this.model.isTeamServicesRepository());
        } else if ("openSelectedItem".equals(e.getActionCommand())) {
            this.model.openSelectedItemsLink();
        } else if ("statusLink".equals(e.getActionCommand())) {
            if (this.model.getTabStatus() == VcsTabStatus.NOT_TF_GIT_REPO) {
                this.model.importIntoTeamServicesGit();
            } else if (this.model.getTabStatus() == VcsTabStatus.NO_AUTH_INFO) {
                this.model.loadData();
            } else {
                this.model.openGitRepoLink();
            }
        } else if ("autoRefreshChanged".equals(e.getActionCommand())) {
            this.model.setAutoRefresh(this.tab.getAutoRefresh());
        }
    }

    @Override
    public JComponent getPanel() {
        return this.tab.getPanel();
    }

    @Override
    public void update(Observable observable, Object arg) {
        if (arg == null || "tabStatus".equals(arg)) {
            this.tab.setStatus(this.model.getTabStatus());
        }
        if (arg == null || "filter".equals(arg)) {
            this.tab.setFilter(this.model.getFilter());
        }
        if (arg == null || "autoRefresh".equals(arg)) {
            this.tab.setAutoRefresh(this.model.getAutoRefresh());
        }
        if (arg == null) {
            this.tab.setViewModel(this.model.getModelForView());
        }
    }

    protected void updateModel() {
        this.model.setFilter(this.tab.getFilter());
        this.model.setAutoRefresh(this.tab.getAutoRefresh());
        this.model.setOperationInputs(this.tab.getOperationInputs());
    }

    @Override
    public void dispose() {
        this.model.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "tab";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
        }
        objectArray[1] = "com/microsoft/alm/plugin/idea/common/ui/common/tabs/TabControllerImpl";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

