/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.common.tabs;

import com.intellij.openapi.project.Project;
import com.microsoft.alm.client.utils.StringUtil;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.idea.common.services.PropertyServiceImpl;
import com.microsoft.alm.plugin.idea.common.ui.common.AbstractModel;
import com.microsoft.alm.plugin.idea.common.ui.common.FilteredModel;
import com.microsoft.alm.plugin.idea.common.ui.common.VcsTabStatus;
import com.microsoft.alm.plugin.idea.common.ui.common.tabs.TabLookupListenerImpl;
import com.microsoft.alm.plugin.idea.common.ui.common.tabs.TabModel;
import com.microsoft.alm.plugin.idea.common.utils.VcsHelper;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.ImportController;
import com.microsoft.alm.plugin.operations.Operation;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TabModelImpl<T extends FilteredModel>
extends AbstractModel
implements TabModel {
    private static final Logger logger = LoggerFactory.getLogger(TabModelImpl.class);
    protected final Project project;
    protected final T viewForModel;
    private final String propertyStoragePrefix;
    protected TabLookupListenerImpl dataProvider;
    protected RepositoryContext repositoryContext;
    private String filter;
    private boolean autoRefresh;
    private VcsTabStatus tabStatus;
    protected Operation.CredInputsImpl operationInputs;

    public TabModelImpl(@NotNull Project project, @NotNull T viewModel, String propertyStoragePrefix) {
        if (project == null) {
            TabModelImpl.$$$reportNull$$$0(0);
        }
        if (viewModel == null) {
            TabModelImpl.$$$reportNull$$$0(1);
        }
        this.filter = "";
        this.tabStatus = VcsTabStatus.NOT_TF_GIT_REPO;
        this.project = project;
        this.viewForModel = viewModel;
        this.propertyStoragePrefix = StringUtil.isNullOrEmpty((String)propertyStoragePrefix) ? "" : propertyStoragePrefix;
        String autoRefreshText = PropertyServiceImpl.getInstance().getProperty(propertyStoragePrefix + "autoRefresh");
        this.autoRefresh = StringUtils.isEmpty((String)autoRefreshText) ? true : Boolean.parseBoolean(autoRefreshText);
        this.createDataProvider();
    }

    protected abstract void createDataProvider();

    @Override
    public abstract void openGitRepoLink();

    @Override
    public VcsTabStatus getTabStatus() {
        return this.tabStatus;
    }

    @Override
    public void setTabStatus(VcsTabStatus status) {
        if (this.tabStatus != status) {
            this.tabStatus = status;
            this.setChangedAndNotify("tabStatus");
        }
    }

    @Override
    public T getModelForView() {
        return this.viewForModel;
    }

    @Override
    public boolean isTeamServicesRepository() {
        this.repositoryContext = VcsHelper.getRepositoryContext(this.project);
        if (this.repositoryContext == null) {
            this.setTabStatus(VcsTabStatus.NOT_TF_GIT_REPO);
            logger.debug("isTeamServicesRepository: Failed to get repo for current project");
            return false;
        }
        return true;
    }

    @Override
    public void loadData() {
        this.loadData(true);
    }

    @Override
    public void loadData(boolean promptForCreds) {
        if (this.isTeamServicesRepository()) {
            logger.info("Loading data for tab. Prompting " + promptForCreds);
            this.getOperationInputs().setPromptForCreds(promptForCreds);
            this.dataProvider.loadData(this.repositoryContext, (Operation.Inputs)this.getOperationInputs());
        }
    }

    @Override
    public void importIntoTeamServicesGit() {
        ImportController controller = new ImportController(this.project);
        controller.showModalDialog();
    }

    @Override
    public abstract void openSelectedItemsLink();

    @Override
    public abstract void appendData(Operation.Results var1);

    @Override
    public abstract void clearData();

    @Override
    public abstract void createNewItem();

    @Override
    public void setFilter(String filter) {
        if (!StringUtils.equals((String)this.filter, (String)filter)) {
            this.filter = filter;
            this.setChangedAndNotify("filter");
            this.viewForModel.setFilter(filter);
        }
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public void setAutoRefresh(boolean autoRefresh) {
        if (this.autoRefresh != autoRefresh) {
            this.autoRefresh = autoRefresh;
            this.setChangedAndNotify("autoRefresh");
            PropertyServiceImpl.getInstance().setProperty(this.propertyStoragePrefix + "autoRefresh", Boolean.toString(autoRefresh));
        }
    }

    @Override
    public boolean getAutoRefresh() {
        return this.autoRefresh;
    }

    @Override
    public Operation.CredInputsImpl getOperationInputs() {
        return this.operationInputs;
    }

    @Override
    public void setOperationInputs(Operation.CredInputsImpl operationInputs) {
        this.operationInputs = operationInputs;
    }

    @Override
    public void dispose() {
        this.dataProvider.terminateActiveOperation();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "viewModel";
                break;
            }
        }
        objectArray[1] = "com/microsoft/alm/plugin/idea/common/ui/common/tabs/TabModelImpl";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

