/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.controls;

import com.intellij.ui.JBColor;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.Timer;

public class BusySpinnerPanel
extends JPanel {
    private int rotationAngle = 0;
    private Timer timer = new Timer(40, new TimerListener(this));

    public BusySpinnerPanel() {
        this.timer.setRepeats(true);
        this.timer.setInitialDelay(40);
        this.timer.setDelay(40);
        this.start(false);
    }

    public void start(boolean show) {
        if (show) {
            this.setVisible(true);
        }
        this.timer.start();
    }

    public void stop(boolean hide) {
        if (hide) {
            this.setVisible(false);
        }
        this.timer.stop();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int width = this.getWidth();
        int height = this.getHeight();
        int lineLength = Math.min(width, height) / 5;
        int lineWidth = lineLength / 4;
        int cx = width / 2;
        int cy = height / 2;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(lineWidth, 1, 1));
        g2.setPaint((Paint)JBColor.black);
        g2.rotate(Math.PI * (double)this.rotationAngle / 180.0, cx, cy);
        for (int i = 0; i < 12; ++i) {
            g2.drawLine(cx + lineLength, cy, cx + lineLength * 2, cy);
            g2.rotate(-0.5235987755982988, cx, cy);
            g2.setComposite(AlphaComposite.getInstance(3, (float)(11 - i) / 12.0f * 0.6666667f));
        }
        g2.dispose();
    }

    private static class TimerListener
    implements ActionListener {
        private BusySpinnerPanel owner;

        public TimerListener(BusySpinnerPanel owner) {
            this.owner = owner;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BusySpinnerPanel busySpinnerPanel = this.owner;
            busySpinnerPanel.rotationAngle = busySpinnerPanel.rotationAngle + 30;
            if (this.owner.rotationAngle >= 360) {
                this.owner.rotationAngle = 0;
            }
            this.owner.repaint();
        }
    }
}

