/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.controls;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public abstract class FilterDropDown
extends JPanel {
    protected final DefaultActionGroup group = new DefaultActionGroup();
    private final ClickListener clickListener = new ClickListener(){

        public boolean onClick(MouseEvent event, int clickCount) {
            FilterDropDown.this.showDropDownMenu();
            return true;
        }
    };
    private final KeyAdapter keyAdapter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 40) {
                FilterDropDown.this.showDropDownMenu();
            }
        }
    };
    protected JLabel titleLabel;
    protected JLabel pickerLabel;
    protected ActionListener listener;
    protected boolean isLoading = false;
    private boolean isEnabled = false;

    protected abstract void populateDropDownMenu();

    public abstract String getSelectedResults();

    protected void initializeUI(String titleLabelText, JLabel pickerLabel) {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(JBUI.scale((int)2), JBUI.scale((int)2), JBUI.scale((int)2), JBUI.scale((int)2)), (Border)JBUI.Borders.empty()));
        this.setLayout(new BoxLayout(this, 0));
        this.titleLabel = new JLabel(titleLabelText + " ");
        this.pickerLabel = pickerLabel;
        this.add(this.titleLabel);
        this.add(this.pickerLabel);
        this.add(Box.createHorizontalStrut(JBUI.scale((int)3)));
        this.add(new JLabel(AllIcons.Ide.Statusbar_arrows));
    }

    public void refreshDropDown(boolean isTeamServicesRepository) {
        if (isTeamServicesRepository != this.isEnabled) {
            this.enableDropDown(isTeamServicesRepository);
        }
        if (this.isEnabled && !this.isLoading) {
            this.populateDropDownMenu();
        }
    }

    private void showDropDownMenu() {
        if (this.isEnabled) {
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)this.group, DataManager.getInstance().getDataContext((Component)this), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
            popup.showUnderneathOf((Component)this);
        }
    }

    protected void addListeners() {
        this.clickListener.installOn((Component)this);
        this.addKeyListener(this.keyAdapter);
    }

    protected void removeListeners() {
        this.clickListener.uninstall((Component)this);
        this.removeKeyListener(this.keyAdapter);
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    protected void enableDropDown(boolean isTeamServicesRepository) {
        JBColor color;
        if (isTeamServicesRepository) {
            this.addListeners();
            color = JBColor.BLACK;
        } else {
            this.removeListeners();
            color = JBColor.GRAY;
        }
        IdeaHelper.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                FilterDropDown.this.pickerLabel.setForeground((Color)color);
            }
        });
        this.isEnabled = isTeamServicesRepository;
    }

    protected class LoadingAction
    extends DumbAwareAction {
        public LoadingAction() {
            super(TfPluginBundle.message("VcsTab.Loading", new Object[0]));
            this.getTemplatePresentation().setText(TfPluginBundle.message("VcsTab.Loading", new Object[0]), false);
            this.getTemplatePresentation().setEnabled(false);
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
        }
    }
}

