/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.controls;

import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Font;
import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class FormattedTable
extends JBTable {
    private static final int DEFAULT_COLUMN_WIDTH = 200;
    private static final int MAX_ROWS_CHECKED = 100;
    private final String defaultLongColumn;
    private boolean isFormatted = false;
    private final TableModelListener formattedListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            if (FormattedTable.this.shouldFormat()) {
                FormattedTable.this.formatTable();
                FormattedTable.this.getModel().removeTableModelListener(this);
            }
        }
    };

    public FormattedTable() {
        this(null);
    }

    public FormattedTable(String defaultLongColumn) {
        this.defaultLongColumn = defaultLongColumn;
        this.setRowHeight(this.getRowHeight() + JBUI.scale((int)10));
        this.getTableHeader().setReorderingAllowed(false);
    }

    public void customizeHeader() {
        JTableHeader header = this.getTableHeader();
        Font headerFont = header.getFont();
        this.getTableHeader().setFont(new Font(headerFont.getFontName(), 1, headerFont.getSize()));
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        if (this.shouldFormat()) {
            this.formatTable();
        }
        if (!this.isFormatted) {
            model.addTableModelListener(this.formattedListener);
        }
    }

    private void formatTable() {
        this.formatColumns();
        this.setAutoCreateColumnsFromModel(false);
        this.isFormatted = true;
    }

    private void formatColumns() {
        Enumeration<TableColumn> columnList = this.getColumnModel().getColumns();
        while (columnList.hasMoreElements()) {
            TableColumn column = columnList.nextElement();
            if (this.defaultLongColumn != null && this.defaultLongColumn.toLowerCase().equals(column.getHeaderValue().toString().toLowerCase())) {
                column.setPreferredWidth(Short.MAX_VALUE);
                continue;
            }
            TableCellRenderer headerRenderer = column.getHeaderRenderer() != null ? column.getHeaderRenderer() : this.getTableHeader().getDefaultRenderer();
            Component headerComponent = headerRenderer.getTableCellRendererComponent((JTable)((Object)this), column.getHeaderValue(), false, false, -1, column.getModelIndex());
            int maxWidth = headerComponent.getPreferredSize().width + JBUI.scale((int)20);
            int maxRowsToCheck = Math.min(100, this.getRowCount());
            for (int row = 0; row < maxRowsToCheck; ++row) {
                TableCellRenderer renderer = this.getCellRenderer(row, column.getModelIndex());
                Component comp = this.prepareRenderer(renderer, row, column.getModelIndex());
                maxWidth = Math.max(comp.getPreferredSize().width, maxWidth);
            }
            column.setMinWidth(Math.min(maxWidth + JBUI.scale((int)10), 200));
            column.setWidth(column.getMinWidth());
        }
    }

    private boolean shouldFormat() {
        return !this.isFormatted && this.getRowCount() > 0;
    }
}

