/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.ui.workitem;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import com.microsoft.alm.common.artifact.GitRefArtifactID;
import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.authentication.AuthHelper;
import com.microsoft.alm.plugin.context.RepositoryContext;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.tabs.TabModelImpl;
import com.microsoft.alm.plugin.idea.common.ui.workitem.WorkItemHelper;
import com.microsoft.alm.plugin.idea.common.ui.workitem.WorkItemsTabLookupListener;
import com.microsoft.alm.plugin.idea.common.ui.workitem.WorkItemsTableModel;
import com.microsoft.alm.plugin.idea.common.utils.EventContextHelper;
import com.microsoft.alm.plugin.idea.common.utils.VcsHelper;
import com.microsoft.alm.plugin.idea.git.ui.branch.CreateBranchController;
import com.microsoft.alm.plugin.operations.Operation;
import com.microsoft.alm.plugin.operations.OperationExecutor;
import com.microsoft.alm.plugin.operations.WorkItemLookupOperation;
import com.microsoft.alm.workitemtracking.webapi.models.Link;
import com.microsoft.alm.workitemtracking.webapi.models.WorkItem;
import com.microsoft.visualstudio.services.webapi.patch.Operation;
import com.microsoft.visualstudio.services.webapi.patch.json.JsonPatchDocument;
import com.microsoft.visualstudio.services.webapi.patch.json.JsonPatchOperation;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcsWorkItemsModel
extends TabModelImpl<WorkItemsTableModel> {
    private static final Logger logger = LoggerFactory.getLogger(VcsWorkItemsModel.class);
    private static final String DEFAULT_BRANCH_NAME_PATTERN = "workitem%s";
    private static final String LINK_NAME_KEY = "name";
    private static final String LINK_NAME_VALUE = "Branch";
    private static final String ARTIFACT_LINK_RELATION = "ArtifactLink";
    private static final String RELATIONS_PATH = "/relations/-";
    public static final String ASSOCIATE_WORK_ITEM_ACTION = "associate-work-item";
    public static final String CONTEXT_FOUND = "context";
    private boolean isContextFound;

    public VcsWorkItemsModel(@NotNull Project project) {
        if (project == null) {
            VcsWorkItemsModel.$$$reportNull$$$0(0);
        }
        super(project, new WorkItemsTableModel(WorkItemsTableModel.COLUMNS_PLUS_BRANCH), "WorkItemsTab.");
        this.isContextFound = false;
        this.operationInputs = new WorkItemLookupOperation.WitInputs(WorkItemHelper.getAssignedToMeQuery());
    }

    @VisibleForTesting
    protected VcsWorkItemsModel(@NotNull Project project, @NotNull WorkItemsTableModel tableModel) {
        if (project == null) {
            VcsWorkItemsModel.$$$reportNull$$$0(1);
        }
        if (tableModel == null) {
            VcsWorkItemsModel.$$$reportNull$$$0(2);
        }
        super(project, tableModel, "WorkItemsTab.");
        this.isContextFound = false;
    }

    @Override
    protected void createDataProvider() {
        this.dataProvider = new WorkItemsTabLookupListener(this);
    }

    public void setContextFound(boolean isFound) {
        if (this.isContextFound != isFound && isFound) {
            logger.info("Context found for work items tab for first time");
            this.isContextFound = isFound;
            this.setChangedAndNotify(CONTEXT_FOUND);
        } else if (this.isContextFound != isFound) {
            logger.warn("Context became invalid and isn't known anymore");
            this.isContextFound = isFound;
        }
    }

    @Override
    public void openGitRepoLink() {
        this.createNewItem();
    }

    @Override
    public void openSelectedItemsLink() {
        ServerContext context;
        if (this.isTeamServicesRepository() && (context = ServerContextManager.getInstance().get(this.repositoryContext.getUrl())) != null) {
            URI teamProjectURI = context.getTeamProjectURI();
            if (teamProjectURI != null) {
                List<WorkItem> workItems = ((WorkItemsTableModel)this.viewForModel).getSelectedWorkItems();
                for (WorkItem item : workItems) {
                    super.gotoLink(UrlHelper.getSpecificWorkItemURI((URI)teamProjectURI, (int)item.getId()).toString());
                }
            } else {
                logger.warn("Can't goto 'create work item' link: Unable to get team project URI from server context.");
            }
        }
    }

    public void createBranch() {
        if (!this.isTeamServicesRepository() || this.repositoryContext.getType() != RepositoryContext.Type.GIT) {
            logger.debug("createBranch: cannot associate a work item with a branch in a non-TF Git repo");
            return;
        }
        final ServerContext context = ServerContextManager.getInstance().get(this.repositoryContext.getUrl());
        final WorkItem workItem = ((WorkItemsTableModel)this.viewForModel).getSelectedWorkItems().get(0);
        final CreateBranchController controller = new CreateBranchController(this.project, String.format(DEFAULT_BRANCH_NAME_PATTERN, workItem.getId()), VcsHelper.getGitRepository(this.project));
        if (controller.showModalDialog()) {
            final String branchName = controller.getBranchName();
            try {
                OperationExecutor.getInstance().submitOperationTask(new Runnable(){

                    @Override
                    public void run() {
                        boolean wasBranchCreated = controller.createBranch(context);
                        boolean wasWorkItemAssociated = false;
                        if (wasBranchCreated) {
                            wasWorkItemAssociated = VcsWorkItemsModel.this.createWorkItemBranchAssociation(context, branchName, workItem.getId());
                            logger.info("Work item association " + (wasWorkItemAssociated ? "succeeded" : "failed"));
                            String notificationMsg = TfPluginBundle.message(wasWorkItemAssociated ? "WitAssociation.Successful.Description" : "WitAssociation.Failed.Description", UrlHelper.getSpecificWorkItemURI((URI)context.getTeamProjectURI(), (int)workItem.getId()), String.valueOf(workItem.getId()), UrlHelper.getBranchURI((URI)context.getUri(), (String)branchName), branchName);
                            VcsNotifier.getInstance((Project)VcsWorkItemsModel.this.project).notifyImportantInfo(TfPluginBundle.message(wasWorkItemAssociated ? "WitAssociation.Successful.Title" : "WitAssociation.Failed.Title", new Object[0]), notificationMsg, new NotificationListener(){

                                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent hyperlinkEvent) {
                                    if (notification == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    if (hyperlinkEvent == null) {
                                        1.$$$reportNull$$$0(1);
                                    }
                                    BrowserUtil.browse((URL)hyperlinkEvent.getURL());
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    Object[] objectArray;
                                    Object[] objectArray2 = new Object[3];
                                    switch (n) {
                                        default: {
                                            objectArray = objectArray2;
                                            objectArray2[0] = "notification";
                                            break;
                                        }
                                        case 1: {
                                            objectArray = objectArray2;
                                            objectArray2[0] = "hyperlinkEvent";
                                            break;
                                        }
                                    }
                                    objectArray[1] = "com/microsoft/alm/plugin/idea/common/ui/workitem/VcsWorkItemsModel$1$1";
                                    objectArray[2] = "hyperlinkUpdate";
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                                }
                            });
                        }
                        EventContextHelper.triggerWorkItemChanged("associateBranch", VcsWorkItemsModel.this.project);
                    }
                });
            }
            catch (Exception e) {
                logger.error("Failed to create a branch and associate it with a work item", (Throwable)e);
            }
        }
    }

    protected boolean createWorkItemBranchAssociation(ServerContext context, String branchName, int workItemId) {
        GitRefArtifactID gitRefArtifactID = new GitRefArtifactID(context.getTeamProjectReference().getId().toString(), context.getGitRepository().getId().toString(), branchName);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(LINK_NAME_KEY, LINK_NAME_VALUE);
        Link link = new Link();
        link.setUrl(gitRefArtifactID.encodeURI());
        link.setTitle("");
        link.setRel(ARTIFACT_LINK_RELATION);
        link.setAttributes(attributes);
        JsonPatchOperation operation = new JsonPatchOperation();
        operation.setOp(Operation.ADD);
        operation.setPath(RELATIONS_PATH);
        operation.setValue((Object)link);
        JsonPatchDocument doc = new JsonPatchDocument();
        doc.add((Object)operation);
        try {
            context.getWitHttpClient().updateWorkItem(doc, workItemId, Boolean.valueOf(false), Boolean.valueOf(false));
            return true;
        }
        catch (Throwable t) {
            if (AuthHelper.isNotAuthorizedError((Throwable)t)) {
                ServerContext newContext = ServerContextManager.getInstance().updateAuthenticationInfo(context.getGitRepository().getRemoteUrl());
                if (newContext != null) {
                    return this.createWorkItemBranchAssociation(newContext, branchName, workItemId);
                }
                logger.error("createWorkItemBranchAssociation isNotAuthorizedError and failed to create a new context to use");
                return false;
            }
            logger.error("createWorkItemBranchAssociation experienced an exception while associating a work item and branch", t);
            return false;
        }
    }

    @Override
    public void appendData(Operation.Results results) {
        WorkItemLookupOperation.WitResults witResults = (WorkItemLookupOperation.WitResults)results;
        ((WorkItemsTableModel)this.viewForModel).addWorkItems(witResults.getWorkItems());
    }

    @Override
    public void clearData() {
        ((WorkItemsTableModel)this.viewForModel).clearRows();
    }

    @Override
    public void createNewItem() {
        ServerContext context;
        if (this.isTeamServicesRepository() && (context = ServerContextManager.getInstance().get(this.repositoryContext.getUrl())) != null) {
            URI teamProjectURI = context.getTeamProjectURI();
            if (teamProjectURI != null) {
                super.gotoLink(UrlHelper.getCreateWorkItemURI((URI)teamProjectURI).toString());
            } else {
                logger.warn("Can't goto 'create work item' link: Unable to get team project URI from server context.");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "tableModel";
                break;
            }
        }
        objectArray[1] = "com/microsoft/alm/plugin/idea/common/ui/workitem/VcsWorkItemsModel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

