/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.utils;

import com.intellij.openapi.project.Project;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.events.ServerEvent;
import com.microsoft.alm.plugin.events.ServerEventManager;
import git4idea.repo.GitRepository;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class EventContextHelper {
    public static final String SENDER_POLLING_MANAGER = "pollingManager";
    public static final String SENDER_PROJECT_OPENED = "projectOpened";
    public static final String SENDER_PROJECT_CLOSING = "projectClosing";
    public static final String SENDER_REPO_CHANGED = "repoChanged";
    public static final String SENDER_ABANDON_PULL_REQUEST = "abandonPullReguest";
    public static final String SENDER_CREATE_PULL_REQUEST = "createPullRequest";
    public static final String SENDER_ASSOCIATE_BRANCH = "associateBranch";
    public static final String CONTEXT_SENDER = "sender";
    public static final String CONTEXT_PROJECT = "project";
    public static final String CONTEXT_REPOSITORY = "repository";

    public static Map<String, Object> createContext(String sender) {
        HashMap<String, Object> eventContext = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)sender)) {
            EventContextHelper.setSender(eventContext, sender);
        }
        return eventContext;
    }

    public static void setSender(Map<String, Object> eventContext, String sender) {
        ArgumentHelper.checkNotNull(eventContext, (String)"eventContext");
        if (sender == null) {
            eventContext.remove(CONTEXT_SENDER);
        } else {
            eventContext.put(CONTEXT_SENDER, sender);
        }
    }

    public static void setProject(Map<String, Object> eventContext, Project project) {
        ArgumentHelper.checkNotNull(eventContext, (String)"eventContext");
        if (project == null) {
            eventContext.remove(CONTEXT_PROJECT);
        } else {
            eventContext.put(CONTEXT_PROJECT, project);
        }
    }

    public static void setRepository(Map<String, Object> eventContext, GitRepository repository) {
        ArgumentHelper.checkNotNull(eventContext, (String)"eventContext");
        if (repository == null) {
            eventContext.remove(CONTEXT_REPOSITORY);
        } else {
            eventContext.put(CONTEXT_REPOSITORY, repository);
        }
    }

    public static String getSender(Map<String, Object> eventContext) {
        ArgumentHelper.checkNotNull(eventContext, (String)"eventContext");
        return (String)eventContext.get(CONTEXT_SENDER);
    }

    public static Project getProject(Map<String, Object> eventContext) {
        ArgumentHelper.checkNotNull(eventContext, (String)"eventContext");
        return (Project)eventContext.get(CONTEXT_PROJECT);
    }

    public static GitRepository getRepository(Map<String, Object> eventContext) {
        ArgumentHelper.checkNotNull(eventContext, (String)"eventContext");
        return (GitRepository)eventContext.get(CONTEXT_REPOSITORY);
    }

    public static boolean isProjectOpened(Map<String, Object> eventContext) {
        String sender = EventContextHelper.getSender(eventContext);
        return SENDER_PROJECT_OPENED.equals(sender) && EventContextHelper.getProject(eventContext) != null;
    }

    public static boolean isProjectClosing(Map<String, Object> eventContext) {
        String sender = EventContextHelper.getSender(eventContext);
        return SENDER_PROJECT_CLOSING.equals(sender) && EventContextHelper.getProject(eventContext) != null;
    }

    public static boolean isRepositoryChanged(Map<String, Object> eventContext) {
        String sender = EventContextHelper.getSender(eventContext);
        return SENDER_REPO_CHANGED.equals(sender) && EventContextHelper.getProject(eventContext) != null;
    }

    public static void triggerPullRequestChanged(String sender, Project project) {
        Map<String, Object> context = EventContextHelper.createContext(sender);
        EventContextHelper.setProject(context, project);
        ServerEventManager.getInstance().triggerEvent(ServerEvent.PULL_REQUESTS_CHANGED, context);
    }

    public static void triggerWorkItemChanged(String sender, Project project) {
        Map<String, Object> context = EventContextHelper.createContext(sender);
        EventContextHelper.setProject(context, project);
        ServerEventManager.getInstance().triggerEvent(ServerEvent.WORK_ITEMS_CHANGED, context);
    }
}

