/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.common.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.microsoft.alm.plugin.external.tools.TfTool;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.services.PluginServiceProvider;
import git4idea.GitVcs;
import git4idea.config.GitExecutableValidator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import javax.swing.Icon;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdeaHelper {
    private static final Logger logger = LoggerFactory.getLogger(IdeaHelper.class);
    private static final String CHARSET_UTF8 = "utf-8";
    public static final String TEST_RESOURCES_SUB_PATH = "/externals/platform/";
    private static final String PROD_RESOURCES_SUB_PATH = "platform";
    public static final String RIDER_PRODUCT_NAME = "Rider";

    public static void setProgress(ProgressIndicator indicator, double fraction, String text) {
        IdeaHelper.setProgress(indicator, fraction, text, false);
    }

    public static void setProgress(final ProgressIndicator indicator, final double fraction, final String text, boolean delay) {
        if (indicator == null) {
            return;
        }
        IdeaHelper.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                indicator.setFraction(fraction);
                indicator.setText(text);
            }
        });
        if (delay) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warn("setting progress failed", (Throwable)e);
            }
        }
    }

    public static boolean isGitExeConfigured(@NotNull Project project) {
        GitExecutableValidator validator;
        if (project == null) {
            IdeaHelper.$$$reportNull$$$0(0);
        }
        if (!(validator = GitVcs.getInstance((Project)project).getExecutableValidator()).checkExecutableAndNotifyIfNeeded()) {
            Messages.showWarningDialog((Project)project, (String)TfPluginBundle.message("Plugin.Error.GitExeNotConfigured", new Object[0]), (String)TfPluginBundle.message("Providers.TfGitCheckoutProvider", new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean isTFConfigured(@NotNull Project project) {
        String tfLocation;
        if (project == null) {
            IdeaHelper.$$$reportNull$$$0(1);
        }
        if (StringUtils.isEmpty((String)(tfLocation = TfTool.getLocation()))) {
            tfLocation = TfTool.tryDetectTf();
            if (!StringUtils.isEmpty((String)tfLocation)) {
                PluginServiceProvider.getInstance().getPropertyService().setProperty("tfHome", tfLocation);
                return true;
            }
            int result = Messages.showDialog((Project)project, (String)TfPluginBundle.message("Plugin.Error.TFNotConfigured", new Object[0]), (String)TfPluginBundle.message("Providers.TfvcCheckoutProvider", new Object[0]), (String[])new String[]{TfPluginBundle.message("Plugin.Error.TFNotConfiguredDialog.OpenSettings", new Object[0]), TfPluginBundle.message("Plugin.Error.TFNotConfiguredDialog.Cancel", new Object[0])}, (int)0, (Icon)Messages.getWarningIcon());
            if (result == 0) {
                ShowSettingsUtil.getInstance().showSettingsDialog(project, "TFVC");
            }
            return false;
        }
        return true;
    }

    public static void runOnUIThread(Runnable runnable) {
        IdeaHelper.runOnUIThread(runnable, false);
    }

    public static void runOnUIThread(Runnable runnable, boolean wait) {
        IdeaHelper.runOnUIThread(runnable, wait, ApplicationManager.getApplication() != null ? ApplicationManager.getApplication().getAnyModalityState() : null);
    }

    public static void runOnUIThread(Runnable runnable, boolean wait, ModalityState modalityState) {
        if (ApplicationManager.getApplication() != null && !ApplicationManager.getApplication().isDispatchThread()) {
            if (wait) {
                ApplicationManager.getApplication().invokeAndWait(runnable, modalityState);
            } else {
                ApplicationManager.getApplication().invokeLater(runnable, modalityState);
            }
        } else {
            runnable.run();
        }
    }

    public static boolean showConfirmationDialog(@NotNull Project project, String message, String title, Icon logo, String okActionMessage, String cancelActionMessage) {
        int result;
        if (project == null) {
            IdeaHelper.$$$reportNull$$$0(2);
        }
        return (result = Messages.showYesNoDialog((Project)project, (String)message, (String)title, (String)okActionMessage, (String)cancelActionMessage, (Icon)logo)) == 0;
    }

    public static void showErrorDialog(@NotNull Project project, Throwable throwable) {
        if (project == null) {
            IdeaHelper.$$$reportNull$$$0(3);
        }
        if (throwable != null && StringUtils.isNotEmpty((String)throwable.getMessage())) {
            IdeaHelper.showErrorDialog(project, throwable.getMessage());
        } else {
            IdeaHelper.showErrorDialog(project, TfPluginBundle.message("Message.TeamServices.Unexpected.Error", new Object[0]));
        }
    }

    public static void showErrorDialog(@NotNull Project project, @NotNull String message) {
        if (project == null) {
            IdeaHelper.$$$reportNull$$$0(4);
        }
        if (message == null) {
            IdeaHelper.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        Messages.showErrorDialog((Project)project, (String)message, (String)TfPluginBundle.message("Title.TeamServices.Error", new Object[0]));
    }

    public static String getResourcePath(URL resourceUrl, String resourceName, String directory) throws UnsupportedEncodingException {
        String resourcePath = resourceUrl.getPath();
        resourcePath = URLDecoder.decode(resourcePath, CHARSET_UTF8);
        if ((resourcePath = StringUtils.chomp((String)resourcePath, (String)"/")) != null && resourcePath.endsWith(PROD_RESOURCES_SUB_PATH)) {
            return resourcePath + "/" + directory + "/" + resourceName;
        }
        return resourcePath + TEST_RESOURCES_SUB_PATH + directory + "/" + resourceName;
    }

    public static void setExecutablePermissions(File executable) throws FileNotFoundException {
        if (!executable.exists()) {
            throw new FileNotFoundException(executable.getPath() + " not found while trying to set permissions.");
        }
        if (!executable.canExecute()) {
            executable.setExecutable(true, false);
        }
    }

    public static Project getCurrentProject() {
        IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        return frame == null || frame.getProject() == null ? ProjectManager.getInstance().getDefaultProject() : frame.getProject();
    }

    public static boolean isRider() {
        return StringUtils.equalsIgnoreCase((String)ApplicationNamesInfo.getInstance().getProductName(), (String)RIDER_PRODUCT_NAME);
    }

    public static void executeOnPooledThread(Runnable runnable) {
        ApplicationManager.getApplication().executeOnPooledThread(runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/microsoft/alm/plugin/idea/common/utils/IdeaHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isGitExeConfigured";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isTFConfigured";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showConfirmationDialog";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

