/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.extensions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.util.NotNullFunction;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.idea.common.utils.VcsHelper;
import com.microsoft.alm.plugin.idea.git.ui.pullrequest.VcsPullRequestsController;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcsPullRequestContentProvider
implements ChangesViewContentProvider {
    private static final Logger logger = LoggerFactory.getLogger(VcsPullRequestContentProvider.class);
    private VcsPullRequestsController controller;
    private Throwable t;

    public VcsPullRequestContentProvider(@NotNull Project project) {
        if (project == null) {
            VcsPullRequestContentProvider.$$$reportNull$$$0(0);
        }
        if (VcsHelper.isGitVcs(project)) {
            try {
                this.controller = new VcsPullRequestsController(project);
            }
            catch (Throwable t) {
                this.t = t;
                this.controller = null;
                logger.error("VcsPullRequestContentProvider: unexpected fatal error initializing the controller", t);
            }
        } else {
            this.controller = null;
        }
    }

    public JComponent initContent() {
        if (this.controller != null) {
            return this.controller.getPanel();
        }
        return new JLabel(TfPluginBundle.message("VcsPullRequestsTab.Unexpected.Errors", this.t.getMessage()), AllIcons.General.Warning, 0);
    }

    public void disposeContent() {
        if (this.controller != null) {
            this.controller.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/microsoft/alm/plugin/idea/git/extensions/VcsPullRequestContentProvider", "<init>"));
    }

    public static class VcsPullRequestVisibilityPredicate
    implements NotNullFunction<Project, Boolean> {
        @NotNull
        public Boolean fun(Project project) {
            if (!VcsHelper.isGitVcs(project)) {
                Boolean bl = false;
                if (bl == null) {
                    VcsPullRequestVisibilityPredicate.$$$reportNull$$$0(0);
                }
                return bl;
            }
            Boolean bl = IdeaHelper.isRider() ? VcsHelper.isVstsRepo(project) : true;
            if (bl == null) {
                VcsPullRequestVisibilityPredicate.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/microsoft/alm/plugin/idea/git/extensions/VcsPullRequestContentProvider$VcsPullRequestVisibilityPredicate", "fun"));
        }
    }
}

