/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.pullrequest;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.ModelValidationInfo;
import com.microsoft.alm.plugin.idea.common.ui.common.ValidationListener;
import com.microsoft.alm.plugin.idea.git.ui.pullrequest.CreatePullRequestDialog;
import com.microsoft.alm.plugin.idea.git.ui.pullrequest.CreatePullRequestModel;
import git4idea.GitBranch;
import git4idea.repo.GitRepository;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;

public class CreatePullRequestController
implements Observer,
ActionListener {
    private CreatePullRequestDialog createDialog;
    private CreatePullRequestModel createModel;

    CreatePullRequestController() {
    }

    public CreatePullRequestController(Project project, GitRepository gitRepository) {
        this(new CreatePullRequestDialog(project), new CreatePullRequestModel(project, gitRepository));
    }

    @VisibleForTesting
    public CreatePullRequestController(CreatePullRequestDialog createDialog, CreatePullRequestModel createModel) {
        this.createDialog = createDialog;
        this.createModel = createModel;
        this.setupDialog();
        this.update(null, null);
        this.createModel.addObserver(this);
        this.createDialog.addActionListener(this);
        this.createModel.loadDiff();
    }

    private void setupDialog() {
        this.createDialog.addValidationListener(new ValidationListener(){

            @Override
            public ValidationInfo doValidate() {
                return CreatePullRequestController.this.validate();
            }
        });
    }

    public void showModalDialog() {
        if (this.sanityCheckOnModel()) {
            this.createDialog.showAndGet();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("cmdTargetBranchDropDownChanged".equals(e.getActionCommand())) {
            this.createModel.setTargetBranch(this.createDialog.getSelectedTargetBranch());
            this.createModel.loadDiff();
        } else if ("ok".equals(e.getActionCommand())) {
            this.createModel.createPullRequest();
        }
    }

    @Override
    public void update(Observable observable, Object arg) {
        if (arg == null || "sourceBranch".equals(arg)) {
            this.createDialog.setSourceBranch((GitBranch)this.createModel.getSourceBranch());
        }
        if (arg == null || "targetBranchComboModel".equals(arg)) {
            this.createDialog.setTargetBranchDropdownModel(this.createModel.getRemoteBranchDropdownModel());
        }
        if (arg == null || "targetBranch".equals(arg)) {
            this.createDialog.setSelectedTargetBranch(this.createModel.getTargetBranch());
        }
        if (arg == null || "title".equals(arg)) {
            this.createDialog.setTitle(this.createModel.getTitle());
        }
        if (arg == null || "description".equals(arg)) {
            this.createDialog.setDescription(this.createModel.getDescription());
        }
        if (arg == null || "loading".equals(arg)) {
            this.createDialog.setIsLoading(this.createModel.isLoading());
        }
        if (arg == null || "diffModel".equals(arg)) {
            this.createDialog.populateDiff(this.createModel.getProject(), this.createModel.getLocalBranchChanges());
        }
    }

    private boolean sanityCheckOnModel() {
        if (this.createModel.getRemoteBranchDropdownModel().getSize() == 0) {
            String warningText = TfPluginBundle.message("CreatePullRequestDialog.NoValidTargetWarning.Message", new Object[0]);
            String warningTitle = TfPluginBundle.message("CreatePullRequestDialog.SanityCheckFailed.Title", new Object[0]);
            Messages.showWarningDialog((String)warningText, (String)warningTitle);
            return false;
        }
        return true;
    }

    private ValidationInfo validate() {
        this.updateModel();
        ModelValidationInfo validationInfo = this.createModel.validate();
        if (validationInfo != ModelValidationInfo.NO_ERRORS) {
            return new ValidationInfo(validationInfo.getValidationMessage(), this.createDialog.getComponent(validationInfo.getValidationSource()));
        }
        return null;
    }

    private void updateModel() {
        this.createModel.setTitle(this.createDialog.getTitle());
        this.createModel.setDescription(this.createDialog.getDescription());
    }

    @VisibleForTesting
    void setCreateDialog(CreatePullRequestDialog createDialog) {
        this.createDialog = createDialog;
    }

    @VisibleForTesting
    void setCreateModel(CreatePullRequestModel createModel) {
        this.createModel = createModel;
    }
}

