/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.pullrequest;

import com.intellij.openapi.project.Project;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.BaseDialogImpl;
import com.microsoft.alm.plugin.idea.git.ui.pullrequest.CreatePullRequestForm;
import com.microsoft.alm.plugin.idea.git.ui.pullrequest.GitChangesContainer;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;

public class CreatePullRequestDialog
extends BaseDialogImpl {
    private CreatePullRequestForm createPullRequestForm;

    public CreatePullRequestDialog(Project project) {
        super(project, TfPluginBundle.message("CreatePullRequestDialog.Title", new Object[0]), TfPluginBundle.message("CreatePullRequestDialog.CreateButton", new Object[0]), "CreatePullRequestDialog.Title");
    }

    @Override
    @Nullable
    protected JComponent createCenterPanel() {
        this.createPullRequestForm = new CreatePullRequestForm();
        JPanel createPRForm = this.createPullRequestForm.getContentPanel();
        createPRForm.setPreferredSize(new Dimension(600, 800));
        return createPRForm;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.createPullRequestForm.getPreferredFocusedComponent();
    }

    @Override
    public void addActionListener(ActionListener listener) {
        super.addActionListener(listener);
        this.createPullRequestForm.addActionListener(listener);
    }

    public void setTargetBranchDropdownModel(ComboBoxModel model) {
        this.createPullRequestForm.setTargetBranchDropdownModel(model);
    }

    public void setSourceBranch(GitBranch currentBranch) {
        this.createPullRequestForm.setSourceBranch(currentBranch);
    }

    public GitRemoteBranch getSelectedTargetBranch() {
        return this.createPullRequestForm.getSelectedRemoteBranch();
    }

    public void populateDiff(Project project, GitChangesContainer changesContainer) {
        if (project != null && changesContainer != null) {
            this.createPullRequestForm.populateDiffPane(project, changesContainer.getGitRepository(), changesContainer.getSourceBranchName(), changesContainer.getTargetBranchName(), changesContainer.getGitCommitCompareInfo());
        }
    }

    public void setTitle(String title) {
        this.createPullRequestForm.setTitleTextField(title);
    }

    public String getTitle() {
        return this.createPullRequestForm.getTitleText();
    }

    public void setDescription(String description) {
        this.createPullRequestForm.setDescriptionTextArea(description);
    }

    public String getDescription() {
        return this.createPullRequestForm.getDescriptionText();
    }

    public JComponent getComponent(String componentPropName) {
        if (StringUtils.isEmpty((String)componentPropName)) {
            return null;
        }
        return this.createPullRequestForm.getComponent(componentPropName);
    }

    public void setSelectedTargetBranch(GitRemoteBranch targetBranch) {
        this.createPullRequestForm.setSelectedTargetBranch(targetBranch);
    }

    public void setIsLoading(boolean loading) {
        this.createPullRequestForm.setLoading(loading);
    }
}

