/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.pullrequest;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.SwingHelper;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.BasicForm;
import com.microsoft.alm.plugin.idea.common.ui.controls.BusySpinnerPanel;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.repo.GitRepository;
import git4idea.ui.GitCommitListWithDiffPanel;
import git4idea.util.GitCommitCompareInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CreatePullRequestForm
implements BasicForm {
    public static final String CMD_TARGET_BRANCH_UPDATED = "cmdTargetBranchDropDownChanged";
    private JComboBox targetBranchDropdown;
    private JLabel sourceBranch;
    private JLabel sourceBranchLabel;
    private JPanel contentPanel;
    private JTabbedPane quickDiffPane;
    private JLabel titleLabel;
    private JTextField titleTextField;
    private JLabel descriptionLabel;
    private JTextArea descriptionTextArea;
    private JLabel targetBranchLabel;
    private JLabel loadingLabel;
    private BusySpinnerPanel spinner;
    private JPanel spinnerPanel;
    private JScrollPane descriptionScrollPane;
    private JSplitPane splitPane;
    private boolean initialized = false;

    public CreatePullRequestForm() {
        this.$$$setupUI$$$();
    }

    @Override
    public JPanel getContentPanel() {
        this.ensureInitialized();
        return this.contentPanel;
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            Dimension spinnerSize = new Dimension(JBUI.scale((int)20), JBUI.scale((int)20));
            this.spinner.setPreferredSize(spinnerSize);
            this.spinner.setMinimumSize(spinnerSize);
            SwingHelper.fixTabKeys(this.descriptionTextArea);
            SwingHelper.setPreferredHeight(this.descriptionScrollPane, 80);
            SwingHelper.copyFontAndMargins(this.descriptionTextArea, this.titleTextField);
            Dimension descriptionScrollPaneSize = new Dimension(JBUI.scale((int)80), JBUI.scale((int)80));
            this.descriptionScrollPane.setPreferredSize(descriptionScrollPaneSize);
            this.descriptionScrollPane.setMinimumSize(descriptionScrollPaneSize);
            this.splitPane.setDividerSize(JBUI.scale((int)7));
            this.initialized = true;
        }
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.titleTextField;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.targetBranchDropdown.addActionListener(listener);
    }

    public void setTargetBranchDropdownModel(ComboBoxModel model) {
        if (model != null) {
            this.targetBranchDropdown.setModel(model);
        }
    }

    public void setSourceBranch(GitBranch currentBranch) {
        if (currentBranch != null) {
            this.sourceBranch.setText(currentBranch.getName());
        }
    }

    public void setTitleTextField(String title) {
        this.titleTextField.setText(title);
    }

    public String getTitleText() {
        return this.titleTextField.getText();
    }

    public void setDescriptionTextArea(String description) {
        this.descriptionTextArea.setText(description);
    }

    public String getDescriptionText() {
        return this.descriptionTextArea.getText();
    }

    public GitRemoteBranch getSelectedRemoteBranch() {
        Object o = this.targetBranchDropdown.getSelectedItem();
        if (o instanceof GitRemoteBranch) {
            return (GitRemoteBranch)this.targetBranchDropdown.getSelectedItem();
        }
        return null;
    }

    public void setSelectedTargetBranch(GitRemoteBranch targetBranch) {
        if (targetBranch != null && this.targetBranchDropdown != null) {
            this.targetBranchDropdown.setSelectedItem(targetBranch);
        }
    }

    public JComponent getComponent(@NotNull String componentPropName) {
        if (componentPropName == null) {
            CreatePullRequestForm.$$$reportNull$$$0(0);
        }
        if (componentPropName.equals("title")) {
            return this.titleTextField;
        }
        if (componentPropName.equals("description")) {
            return this.descriptionTextArea;
        }
        if (componentPropName.equals("sourceBranch")) {
            return this.sourceBranch;
        }
        if (componentPropName.equals("targetBranch")) {
            return this.targetBranchDropdown;
        }
        return null;
    }

    public void setLoading(boolean loading) {
        if (loading) {
            this.quickDiffPane.removeAll();
            this.spinnerPanel.setVisible(true);
            this.spinner.start(true);
        } else {
            this.spinnerPanel.setVisible(false);
            this.spinner.start(false);
        }
    }

    public synchronized void populateDiffPane(@NotNull Project project, @NotNull GitRepository gitRepository, @NotNull String sourceBranchBeingCompared, @NotNull String targetBranchBeingCompared, @NotNull GitCommitCompareInfo myCompareInfo) {
        if (project == null) {
            CreatePullRequestForm.$$$reportNull$$$0(1);
        }
        if (gitRepository == null) {
            CreatePullRequestForm.$$$reportNull$$$0(2);
        }
        if (sourceBranchBeingCompared == null) {
            CreatePullRequestForm.$$$reportNull$$$0(3);
        }
        if (targetBranchBeingCompared == null) {
            CreatePullRequestForm.$$$reportNull$$$0(4);
        }
        if (myCompareInfo == null) {
            CreatePullRequestForm.$$$reportNull$$$0(5);
        }
        GitRemoteBranch gitRemoteBranch = this.getSelectedRemoteBranch();
        String currBranch = this.sourceBranch.getText();
        if (gitRemoteBranch != null && StringUtils.equals((String)gitRemoteBranch.getName(), (String)targetBranchBeingCompared) && StringUtils.isNotEmpty((String)currBranch) && StringUtils.equals((String)currBranch, (String)sourceBranchBeingCompared)) {
            this.quickDiffPane.removeAll();
            JComponent myDiffPanel = this.createDiffPaneBrowser(project, myCompareInfo);
            this.quickDiffPane.addTab(TfPluginBundle.message("CreatePullRequestDialog.ChangesPane.Title", new Object[0]), AllIcons.Actions.Diff, myDiffPanel);
            JComponent myCommitsPanel = this.createCommitsListPane(project, gitRepository, myCompareInfo);
            this.quickDiffPane.addTab(TfPluginBundle.message("CreatePullRequestDialog.CommitsPane.Title", new Object[0]), AllIcons.Actions.Commit, myCommitsPanel);
        }
    }

    private JComponent createCommitsListPane(Project project, GitRepository gitRepository, GitCommitCompareInfo compareInfo) {
        return new GitCommitListWithDiffPanel(project, compareInfo.getBranchToHeadCommits(gitRepository));
    }

    private JComponent createDiffPaneBrowser(Project project, GitCommitCompareInfo compareInfo) {
        List diff = compareInfo.getTotalDiff();
        ChangesBrowser changesBrowser = new ChangesBrowser(project, null, diff, null, false, true, null, ChangesBrowser.MyUseCase.COMMITTED_CHANGES, null);
        changesBrowser.setChangesToDisplay(diff);
        return changesBrowser;
    }

    private void createUIComponents() {
        this.targetBranchDropdown = new JComboBox();
        this.targetBranchDropdown.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object gitRemoteBranch, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, gitRemoteBranch != null ? ((GitRemoteBranch)gitRemoteBranch).getName() : "", index, isSelected, cellHasFocus);
            }
        });
        this.targetBranchDropdown.setActionCommand(CMD_TARGET_BRANCH_UPDATED);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        BusySpinnerPanel busySpinnerPanel;
        JPanel jPanel;
        JTabbedPane jTabbedPane;
        JTextArea jTextArea;
        JScrollPane jScrollPane;
        JSplitPane jSplitPane;
        JLabel jLabel2;
        JLabel jLabel3;
        JTextField jTextField;
        JLabel jLabel4;
        JLabel jLabel5;
        JLabel jLabel6;
        JPanel jPanel2;
        this.createUIComponents();
        this.contentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(9, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.sourceBranchLabel = jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CreatePullRequestDialog.SourceBranchLabel"));
        jPanel2.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.titleLabel = jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CreatePullRequestDialog.TitleLabel"));
        jPanel2.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.descriptionLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CreatePullRequestDialog.DescriptionLabel"));
        jPanel2.add((Component)jLabel4, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.titleTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(5, 0, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.targetBranchLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CreatePullRequestDialog.TargetBranchLabel"));
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = this.targetBranchDropdown;
        jPanel2.add((Component)jComboBox, new GridConstraints(2, 0, 1, 4, 8, 1, 2, 0, null, null, null));
        this.sourceBranch = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 1, 1, 2, 8, 0, 6, 0, null, null, null));
        this.splitPane = jSplitPane = new JSplitPane();
        jSplitPane.setOrientation(0);
        jPanel2.add((Component)jSplitPane, new GridConstraints(7, 0, 1, 4, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        this.descriptionScrollPane = jScrollPane = new JScrollPane();
        jSplitPane.setLeftComponent(jScrollPane);
        this.descriptionTextArea = jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jScrollPane.setViewportView(jTextArea);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel3);
        this.quickDiffPane = jTabbedPane = new JTabbedPane();
        jPanel3.add((Component)jTabbedPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        this.spinnerPanel = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 5, 5));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        this.spinner = busySpinnerPanel = new BusySpinnerPanel();
        Component component = jPanel.add(busySpinnerPanel);
        this.loadingLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/microsoft/alm/plugin/idea/ui/tfplugin").getString("CreatePullRequestDialog.LoadingDiffLabel"));
        Component component2 = jPanel.add(jLabel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentPropName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRepository";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceBranchBeingCompared";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetBranchBeingCompared";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myCompareInfo";
                break;
            }
        }
        objectArray2[1] = "com/microsoft/alm/plugin/idea/git/ui/pullrequest/CreatePullRequestForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "populateDiffPane";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

