/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.vcsimport;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.microsoft.alm.plugin.context.ServerContextManager;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.ui.common.BaseDialog;
import com.microsoft.alm.plugin.idea.common.ui.common.BaseDialogImpl;
import com.microsoft.alm.plugin.idea.common.ui.common.ModelValidationInfo;
import com.microsoft.alm.plugin.idea.common.ui.common.ValidationListener;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.LoginForm;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.TfsLoginForm;
import com.microsoft.alm.plugin.idea.common.ui.common.forms.VsoLoginForm;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.ImportForm;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.ImportModel;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.ImportPage;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.ImportPageController;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.ImportPageImpl;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.ImportPageModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;

public class ImportController
implements Observer {
    private final BaseDialog dialog;
    private final ImportModel model;
    private final ImportPageController vsoPageController;
    private final ImportPageController tfsPageController;
    public static final int TAB_VSO = 0;
    public static final int TAB_TFS = 1;

    public ImportController(Project project) {
        this(new BaseDialogImpl(project, TfPluginBundle.message("ImportDialog.Title", new Object[0]), TfPluginBundle.message("ImportDialog.ImportButton", new Object[0]), "ImportDialog.Title"), new ImportPageImpl((LoginForm)new VsoLoginForm(), new ImportForm(true)), new ImportPageImpl((LoginForm)new TfsLoginForm(), new ImportForm(false)), new ImportModel(project));
    }

    public ImportController(BaseDialog importDialog, ImportPage vsoImportPage, ImportPage tfsImportPage, ImportModel importModel) {
        this.dialog = importDialog;
        this.model = importModel;
        this.vsoPageController = new ImportPageController(this, this.model.getVsoImportPageModel(), vsoImportPage);
        this.tfsPageController = new ImportPageController(this, this.model.getTfsImportPageModel(), tfsImportPage);
        this.setupDialog();
        importModel.addObserver(this);
    }

    public ImportModel getModel() {
        return this.model;
    }

    public void gotoEnterVsoURL() {
        this.model.getTfsImportPageModel().signOut();
        this.model.setVsoSelected(false);
    }

    public boolean showModalDialog() {
        return this.dialog.showModalDialog();
    }

    @Override
    public void update(Observable o, Object arg) {
        if ("importEnabled".equals(arg)) {
            this.dialog.setOkEnabled(this.model.isImportEnabled());
        } else if ("vsoSelected".equals(arg)) {
            this.dialog.setSelectedTabIndex(this.model.isVsoSelected() ? 0 : 1);
            this.dialog.setOkEnabled(this.model.isImportEnabled());
        } else if ("errors".equals(arg)) {
            if (this.model.hasErrors()) {
                this.dialog.displayError(this.model.getErrors().get(0).getValidationMessage());
            } else {
                this.dialog.displayError(null);
            }
        }
    }

    private void setupDialog() {
        this.dialog.addTabPage(TfPluginBundle.message("ImportDialog.VsoTab", new Object[0]), this.vsoPageController.getPageAsPanel());
        this.dialog.addTabPage(TfPluginBundle.message("ImportDialog.TfsTab", new Object[0]), this.tfsPageController.getPageAsPanel());
        this.dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("ok".equals(e.getActionCommand())) {
                    ImportController.this.importIntoRepo();
                } else if ("cancel".equals(e.getActionCommand())) {
                    ImportController.this.model.dispose();
                } else if ("tabChanged".equals(e.getActionCommand())) {
                    ImportController.this.model.clearErrors();
                    ImportController.this.model.setVsoSelected(ImportController.this.dialog.getSelectedTabIndex() == 0);
                }
            }
        });
        this.dialog.addValidationListener(new ValidationListener(){

            @Override
            public ValidationInfo doValidate() {
                return ImportController.this.validate();
            }
        });
        if (ServerContextManager.getInstance().lastUsedContextIsTFS()) {
            this.dialog.setSelectedTabIndex(1);
        }
        this.dialog.setOkEnabled(this.model.isImportEnabled());
    }

    private void importIntoRepo() {
        ImportPageModel pageModel = this.getActivePageModel();
        pageModel.importIntoRepository();
    }

    private ValidationInfo validate() {
        ValidationInfo result;
        ImportPageModel pageModel = this.getActivePageModel();
        ModelValidationInfo error = this.model.hasErrors() ? this.model.getErrors().get(0) : pageModel.validate();
        if (error != null) {
            JComponent errorSource = this.model.isVsoSelected() ? this.vsoPageController.getComponent(error.getValidationSource()) : this.tfsPageController.getComponent(error.getValidationSource());
            result = new ValidationInfo(error.getValidationMessage(), errorSource);
        } else {
            result = null;
        }
        return result;
    }

    private ImportPageModel getActivePageModel() {
        ImportPageModel pageModel;
        if (this.model.isVsoSelected()) {
            this.vsoPageController.updateModel();
            pageModel = this.model.getVsoImportPageModel();
        } else {
            this.tfsPageController.updateModel();
            pageModel = this.model.getTfsImportPageModel();
        }
        return pageModel;
    }
}

