/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.git.ui.vcsimport;

import com.microsoft.alm.common.utils.UrlHelper;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.authentication.AuthenticationProvider;
import com.microsoft.alm.plugin.authentication.TfsAuthenticationProvider;
import com.microsoft.alm.plugin.authentication.VsoAuthenticationProvider;
import com.microsoft.alm.plugin.idea.common.ui.common.LookupHelper;
import com.microsoft.alm.plugin.idea.common.ui.common.ServerContextTableModel;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.ImportModel;
import com.microsoft.alm.plugin.idea.git.ui.vcsimport.ImportPageModelImpl;
import com.microsoft.alm.plugin.operations.ServerContextLookupOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TfsImportPageModel
extends ImportPageModelImpl {
    private AuthenticationProvider authenticationProvider;
    private static final Logger logger = LoggerFactory.getLogger(TfsImportPageModel.class);

    public TfsImportPageModel(ImportModel importModel) {
        super(importModel, ServerContextTableModel.TFS_PROJECT_COLUMNS);
        this.setConnected(false);
        this.setAuthenticating(false);
        if (!UrlHelper.isTeamServicesUrl((String)this.getServerName())) {
            this.authenticationProvider = TfsAuthenticationProvider.getInstance();
            if (this.authenticationProvider.isAuthenticated(this.getServerName())) {
                logger.info("TFS auth info already found so reusing that for loading repos");
                AuthenticationInfo info = this.authenticationProvider.getAuthenticationInfo(this.getServerName());
                this.setServerNameInternal(info.getServerUri());
                LookupHelper.loadTfsContexts(this, this, this.authenticationProvider, this.getTeamProjectProvider(), ServerContextLookupOperation.ContextScope.PROJECT);
            }
        } else {
            this.authenticationProvider = VsoAuthenticationProvider.getInstance();
            if (this.authenticationProvider.isAuthenticated(this.getServerName())) {
                logger.info("VSTS auth info already found so reusing that for loading repos");
                this.setServerNameInternal(this.authenticationProvider.getAuthenticationInfo(this.getServerName()).getServerUri());
                LookupHelper.loadVsoContexts(this, this, this.authenticationProvider, this.getTeamProjectProvider(), ServerContextLookupOperation.ContextScope.PROJECT);
            }
        }
    }

    @Override
    protected AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationProvider.getAuthenticationInfo(this.getServerName());
    }

    @Override
    public void signOut() {
        super.signOut();
        this.authenticationProvider.clearAuthenticationDetails(this.getServerName());
    }

    @Override
    public void loadTeamProjects() {
        if (!UrlHelper.isTeamServicesUrl((String)this.getServerName())) {
            this.authenticationProvider = TfsAuthenticationProvider.getInstance();
            LookupHelper.authenticateAndLoadTfsContexts(this, this, this.authenticationProvider, this.getTeamProjectProvider(), ServerContextLookupOperation.ContextScope.PROJECT);
        } else {
            this.authenticationProvider = VsoAuthenticationProvider.getInstance();
            LookupHelper.authenticateAndLoadVsoContexts(this, this, this.authenticationProvider, this.getTeamProjectProvider(), ServerContextLookupOperation.ContextScope.PROJECT);
        }
    }
}

