/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsFileUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAction
extends DumbAwareAction {
    private static final Logger logger = LoggerFactory.getLogger(AddAction.class);

    public void actionPerformed(AnActionEvent anActionEvent) {
        final Project project = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
        final VirtualFile[] files = VcsUtil.getVirtualFiles((AnActionEvent)anActionEvent);
        final ArrayList errors = new ArrayList();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                errors.addAll(TFSVcs.getInstance(project).getCheckinEnvironment().scheduleUnversionedFilesForAddition(Arrays.asList(files)));
            }
        }, TfPluginBundle.message("Tfvc.Add.Scheduling", new Object[0]), false, project);
        if (!errors.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)project).showErrors(errors, "TFVC");
        }
    }

    public void update(AnActionEvent anActionEvent) {
        Project project = anActionEvent.getProject();
        VirtualFile[] files = VcsUtil.getVirtualFiles((AnActionEvent)anActionEvent);
        anActionEvent.getPresentation().setEnabled(AddAction.isEnabled(project, files));
    }

    private static boolean isEnabled(Project project, VirtualFile[] files) {
        if (files.length == 0) {
            return false;
        }
        if (project == null) {
            logger.warn("Cannot enable AddAction because project is unknown (null)");
            return false;
        }
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project);
        return TfsFileUtil.findUnknownFiles(files, fileStatusManager);
    }
}

