/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.actions;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.alm.helpers.Path;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.exceptions.BranchAlreadyExistsException;
import com.microsoft.alm.plugin.external.exceptions.SyncException;
import com.microsoft.alm.plugin.external.models.SyncResults;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.common.services.LocalizationServiceImpl;
import com.microsoft.alm.plugin.idea.common.utils.IdeaHelper;
import com.microsoft.alm.plugin.idea.tfvc.actions.SingleItemAction;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsFileUtil;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.VersionControlPath;
import com.microsoft.alm.plugin.idea.tfvc.ui.CreateBranchDialog;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchAction
extends SingleItemAction {
    private static final Logger logger = LoggerFactory.getLogger(BranchAction.class);

    public BranchAction() {
        super(TfPluginBundle.message("Actions.Tfvc.Branch.Title", new Object[0]), TfPluginBundle.message("Actions.Tfvc.Branch.Message", new Object[0]));
    }

    @Override
    protected void execute(final @NotNull SingleItemAction.SingleItemActionContext actionContext) {
        if (actionContext == null) {
            BranchAction.$$$reportNull$$$0(0);
        }
        logger.info("executing...");
        try {
            final ServerContext serverContext = actionContext.getServerContext();
            final Project project = actionContext.getProject();
            final String sourceServerPath = actionContext.getItem().getServerItem();
            final boolean isFolder = actionContext.getItem().isFolder();
            final String workingFolder = isFolder ? actionContext.getItem().getLocalItem() : Path.getDirectoryName((String)actionContext.getItem().getLocalItem());
            logger.info("Working folder: " + workingFolder);
            logger.info("Opening branch dialog for " + sourceServerPath);
            final CreateBranchDialog d = new CreateBranchDialog(project, serverContext, sourceServerPath, isFolder);
            if (!d.showAndGet()) {
                return;
            }
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    String message;
                    ProgressManager.getInstance().getProgressIndicator().setFraction(0.1);
                    Workspace workspace = CommandUtils.getWorkspace((ServerContext)serverContext, (Project)actionContext.getProject());
                    if (workspace == null) {
                        throw new RuntimeException(TfPluginBundle.message("Errors.UnableToDetermineWorkspace", new Object[0]));
                    }
                    ProgressManager.getInstance().getProgressIndicator().setFraction(0.3);
                    String targetServerPath = d.getTargetPath();
                    logger.info("TargetServerPath from dialog: " + targetServerPath);
                    String targetLocalPath = "";
                    if (d.isCreateWorkingCopies()) {
                        logger.info("User selected to sync the new branched copies");
                        targetLocalPath = CommandUtils.tryGetLocalPath((ServerContext)serverContext, (String)targetServerPath, (String)workspace.getName());
                        ProgressManager.getInstance().getProgressIndicator().setFraction(0.5);
                        logger.info("targetLocalPath: " + targetLocalPath);
                        if (StringUtils.isEmpty((String)targetLocalPath)) {
                            logger.info("Opening the FileChooser dialog for the user to select where the unmapped branch should be mapped to.");
                            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                            descriptor.setTitle(TfPluginBundle.message("Actions.Tfvc.Branch.FileChoose.Title", new Object[0]));
                            descriptor.setShowFileSystemRoots(true);
                            message = TfPluginBundle.message("Actions.Tfvc.Branch.FileChoose.Description", targetServerPath, workspace.getName());
                            descriptor.setDescription(message);
                            VirtualFile selectedFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
                            if (selectedFile == null) {
                                logger.info("User canceled");
                                return;
                            }
                            targetLocalPath = TfsFileUtil.getFilePath(selectedFile).getPath();
                            logger.info("Adding workspace mapping: " + targetServerPath + " -> " + targetLocalPath);
                            CommandUtils.addWorkspaceMapping((ServerContext)serverContext, (String)workspace.getName(), (String)targetServerPath, (String)targetLocalPath);
                        }
                    }
                    ProgressManager.getInstance().getProgressIndicator().setFraction(0.6);
                    logger.info("Creating branch... isFolder: " + isFolder);
                    String comment = TfPluginBundle.message("Actions.Tfvc.Branch.Comment", sourceServerPath);
                    try {
                        CommandUtils.createBranch((ServerContext)serverContext, (String)workingFolder, (boolean)true, (String)comment, null, (String)sourceServerPath, (String)targetServerPath);
                    }
                    catch (BranchAlreadyExistsException e) {
                        logger.warn("Branch already exists");
                        IdeaHelper.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                Messages.showErrorDialog((Project)actionContext.getProject(), (String)LocalizationServiceImpl.getInstance().getExceptionMessage((Throwable)e), (String)TfPluginBundle.message("Actions.Tfvc.Branch.Message.Title", new Object[0]));
                            }
                        });
                        return;
                    }
                    ProgressManager.getInstance().getProgressIndicator().setFraction(0.7);
                    if (d.isCreateWorkingCopies()) {
                        logger.info("Get the latest for the branched folder...");
                        String localPath = targetLocalPath;
                        ArrayList<VcsException> errors = new ArrayList<VcsException>();
                        logger.info("Syncing: " + localPath);
                        SyncResults syncResults = CommandUtils.syncWorkspace((ServerContext)serverContext, (String)localPath);
                        ProgressManager.getInstance().getProgressIndicator().setFraction(0.8);
                        if (syncResults.getExceptions().size() > 0) {
                            for (SyncException se : syncResults.getExceptions()) {
                                errors.add(TFSVcs.convertToVcsException((Throwable)se));
                            }
                        }
                        if (!errors.isEmpty()) {
                            logger.info("Errors found");
                            AbstractVcsHelper.getInstance((Project)project).showErrors(errors, TfPluginBundle.message("Actions.Tfvc.Branch.Message.Title", new Object[0]));
                        }
                    }
                    targetLocalPath = CommandUtils.tryGetLocalPath((ServerContext)serverContext, (String)targetServerPath, (String)workspace.getName());
                    ProgressManager.getInstance().getProgressIndicator().setFraction(0.9);
                    logger.info("targetLocalPath: " + targetLocalPath);
                    if (StringUtils.isNotEmpty((String)targetLocalPath)) {
                        logger.info("Refresh target parent directory to display in the editor.");
                        File targetFile = new File(targetLocalPath);
                        FilePath[] parent = new FilePath[]{VersionControlPath.getFilePath(targetFile.getParent(), true)};
                        TfsFileUtil.refreshAndInvalidate(project, parent, false);
                    }
                    message = TfPluginBundle.message("Actions.Tfvc.Branch.Message.Success", sourceServerPath, targetServerPath);
                    IdeaHelper.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showInfoMessage((Project)project, (String)message, (String)TfPluginBundle.message("Actions.Tfvc.Branch.Message.Title", new Object[0]));
                        }
                    });
                }
            }, TfPluginBundle.message("Actions.Tfvc.Branch.Sync.Progress", new Object[0]), false, project);
        }
        catch (Throwable t) {
            logger.warn("Branching failed", t);
            String message = TfPluginBundle.message("Actions.Tfvc.Branch.Message.Failure", t.getMessage());
            Messages.showErrorDialog((Project)actionContext.getProject(), (String)message, (String)TfPluginBundle.message("Actions.Tfvc.Branch.Message.Title", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionContext", "com/microsoft/alm/plugin/idea/tfvc/actions/BranchAction", "execute"));
    }
}

