/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.tfvc.actions.MultipleItemAction;
import com.microsoft.alm.plugin.idea.tfvc.ui.ApplyLabelDialog;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelAction
extends MultipleItemAction {
    public static final Logger logger = LoggerFactory.getLogger(LabelAction.class);

    public LabelAction() {
        super(TfPluginBundle.message("Actions.Tfvc.Label.Title", new Object[0]), TfPluginBundle.message("Actions.Tfvc.Label.Message", new Object[0]));
    }

    @Override
    protected void execute(final @NotNull MultipleItemAction.MultipleItemActionContext actionContext) {
        ApplyLabelDialog d;
        if (actionContext == null) {
            LabelAction.$$$reportNull$$$0(0);
        }
        if (!(d = new ApplyLabelDialog(actionContext.project, actionContext.itemInfos)).showAndGet()) {
            logger.info("User canceled Apply Label action");
            actionContext.cancelled = true;
            return;
        }
        final ArrayList labels = new ArrayList();
        this.runWithProgress(actionContext, new Runnable(){

            @Override
            public void run() {
                logger.info("Getting labels that match: " + d.getLabelName());
                labels.addAll(CommandUtils.getLabels((ServerContext)actionContext.serverContext, (String)actionContext.workingFolder, (String)d.getLabelName()));
            }
        }, TfPluginBundle.message("Actions.Tfvc.Label.Progress.GatheringInformation", new Object[0]));
        if (actionContext.hasErrors()) {
            logger.info("Errors occurred. Returning control to the super class.");
            return;
        }
        if (!labels.isEmpty()) {
            logger.info("There is a label on the server already with the name " + d.getLabelName());
            if (Messages.showOkCancelDialog((Project)actionContext.project, (String)TfPluginBundle.message("Actions.Tfvc.Label.Overwrite", d.getLabelName()), (String)TfPluginBundle.message("Actions.Tfvc.Label.Title", new Object[0]), (String)TfPluginBundle.message("Actions.Tfvc.Label.Overwrite.OkText", new Object[0]), (String)TfPluginBundle.message("Actions.Tfvc.Label.Overwrite.CancelText", new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                logger.info("User canceled Update Label action");
                actionContext.cancelled = true;
                return;
            }
        }
        final StringBuilder successMessage = new StringBuilder();
        this.runWithProgress(actionContext, new Runnable(){

            @Override
            public void run() {
                logger.info("Creating/Updating the label on the server");
                boolean labelCreated = CommandUtils.createLabel((ServerContext)actionContext.serverContext, (String)actionContext.workingFolder, (String)d.getLabelName(), (String)d.getLabelComment(), (boolean)d.isRecursiveChecked(), d.getLabelItemSpecs());
                if (labelCreated) {
                    successMessage.append(TfPluginBundle.message("Actions.Tfvc.Label.Success.Created", d.getLabelName()));
                } else {
                    successMessage.append(TfPluginBundle.message("Actions.Tfvc.Label.Success.Updated", d.getLabelName()));
                }
            }
        }, TfPluginBundle.message("Actions.Tfvc.Label.Progress.CreatingLabel", new Object[0]));
        if (!actionContext.hasErrors()) {
            logger.info("Label successfully created/updated");
            this.showSuccess(actionContext, TfPluginBundle.message("Actions.Tfvc.Label.Title", new Object[0]), successMessage.toString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionContext", "com/microsoft/alm/plugin/idea/tfvc/actions/LabelAction", "execute"));
    }
}

