/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core;

import com.intellij.openapi.vcs.FilePath;
import com.microsoft.alm.plugin.external.models.ChangeSet;
import com.microsoft.alm.plugin.external.models.CheckedInChange;
import com.microsoft.alm.plugin.external.models.ServerStatusType;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSChangeList;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsFileUtil;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.VersionControlPath;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFSChangeListBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TFSChangeListBuilder.class);
    private final TFSVcs vcs;
    private final Workspace workspace;
    private final Map<String, FilePath> filePathCache;

    public TFSChangeListBuilder(TFSVcs vcs, Workspace workspace) {
        this.vcs = vcs;
        this.workspace = workspace;
        this.filePathCache = new HashMap<String, FilePath>();
    }

    public TFSChangeList createChangeList(ChangeSet changeSet, int previousChangeSetId, String previousChangeSetDate) {
        ArrayList<FilePath> addedFiles = new ArrayList<FilePath>(changeSet.getChanges().size());
        ArrayList<FilePath> deletedFiles = new ArrayList<FilePath>(changeSet.getChanges().size());
        ArrayList<FilePath> renamedFiles = new ArrayList<FilePath>(changeSet.getChanges().size());
        ArrayList<FilePath> editedFiles = new ArrayList<FilePath>(changeSet.getChanges().size());
        for (CheckedInChange pendingChange : changeSet.getChanges()) {
            FilePath path;
            if (this.filePathCache.containsKey(pendingChange.getServerItem())) {
                path = this.filePathCache.get(pendingChange.getServerItem());
            } else {
                String localPath = TfsFileUtil.translateServerItemToLocalItem(this.workspace.getMappings(), pendingChange.getServerItem());
                if (StringUtils.isEmpty((String)localPath)) {
                    logger.warn("Could not find a local path for file: " + pendingChange.getServerItem());
                    continue;
                }
                File file = new File(localPath);
                path = VersionControlPath.getFilePath(file.getPath(), file.isDirectory());
                this.filePathCache.put(pendingChange.getServerItem(), path);
            }
            if (pendingChange.getChangeTypes().contains(ServerStatusType.ADD) || pendingChange.getChangeTypes().contains(ServerStatusType.UNDELETE) || pendingChange.getChangeTypes().contains(ServerStatusType.BRANCH)) {
                addedFiles.add(path);
                continue;
            }
            if (pendingChange.getChangeTypes().contains(ServerStatusType.DELETE)) {
                deletedFiles.add(path);
                continue;
            }
            if (pendingChange.getChangeTypes().contains(ServerStatusType.RENAME)) {
                renamedFiles.add(path);
                continue;
            }
            if (!pendingChange.getChangeTypes().contains(ServerStatusType.EDIT) && !pendingChange.getChangeTypes().contains(ServerStatusType.MERGE)) continue;
            editedFiles.add(path);
        }
        return new TFSChangeList(addedFiles, deletedFiles, renamedFiles, editedFiles, changeSet.getIdAsInt(), changeSet.getCommitter(), changeSet.getComment(), changeSet.getDate(), previousChangeSetId, previousChangeSetDate, this.vcs, this.workspace.getName());
    }
}

