/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.idea.tfvc.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.models.ChangeSet;
import com.microsoft.alm.plugin.external.models.VersionSpec;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.external.utils.CommandUtils;
import com.microsoft.alm.plugin.idea.common.resources.TfPluginBundle;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSChangeList;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSChangeListBuilder;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSRepositoryLocation;
import com.microsoft.alm.plugin.idea.tfvc.core.TFSVcs;
import com.microsoft.alm.plugin.idea.tfvc.core.tfs.TfsRevisionNumber;
import com.microsoft.alm.plugin.idea.tfvc.ui.TFSVersionFilterComponent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFSCommittedChangesProvider
implements CachingCommittedChangesProvider<TFSChangeList, ChangeBrowserSettings> {
    public static final Logger logger = LoggerFactory.getLogger(TFSCommittedChangesProvider.class);
    private final Project project;
    private final TFSVcs vcs;

    public TFSCommittedChangesProvider(Project project) {
        this.project = project;
        this.vcs = TFSVcs.getInstance(this.project);
    }

    @NotNull
    public ChangeBrowserSettings createDefaultSettings() {
        ChangeBrowserSettings changeBrowserSettings = new ChangeBrowserSettings();
        if (changeBrowserSettings == null) {
            TFSCommittedChangesProvider.$$$reportNull$$$0(0);
        }
        return changeBrowserSettings;
    }

    public ChangesBrowserSettingsEditor<ChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        return new TFSVersionFilterComponent(showDateFilter);
    }

    @Nullable
    public VcsCommittedListsZipper getZipper() {
        return null;
    }

    @Nullable
    public RepositoryLocation getLocationFor(FilePath root, String repositoryPath) {
        return this.getLocationFor(root);
    }

    public RepositoryLocation getLocationFor(FilePath root) {
        Workspace workspace = CommandUtils.getPartialWorkspace((Project)this.project);
        return new TFSRepositoryLocation(workspace, root.getVirtualFile());
    }

    public Pair<TFSChangeList, FilePath> getOneList(VirtualFile file, VcsRevisionNumber number) throws VcsException {
        ChangeBrowserSettings settings = this.createDefaultSettings();
        settings.USE_CHANGE_AFTER_FILTER = true;
        settings.USE_CHANGE_BEFORE_FILTER = true;
        settings.CHANGE_BEFORE = settings.CHANGE_AFTER = String.valueOf(((TfsRevisionNumber)number).getValue());
        FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
        List<TFSChangeList> list = this.getCommittedChanges(settings, this.getLocationFor(filePath), 1);
        if (list.size() == 1) {
            return Pair.create((Object)list.get(0), (Object)filePath);
        }
        return null;
    }

    public RepositoryLocation getForNonLocal(VirtualFile file) {
        return null;
    }

    public boolean supportsIncomingChanges() {
        return true;
    }

    public void loadCommittedChanges(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount, AsynchConsumer<CommittedChangeList> consumer) throws VcsException {
        VersionSpec versionFrom = VersionSpec.create((int)1);
        if (settings.getChangeAfterFilter() != null) {
            versionFrom = VersionSpec.create((int)((int)settings.getChangeAfterFilter().longValue()));
        }
        if (settings.getDateAfterFilter() != null) {
            versionFrom = VersionSpec.create((Date)settings.getDateAfterFilter());
        }
        VersionSpec versionTo = VersionSpec.LATEST;
        if (settings.getChangeBeforeFilter() != null) {
            versionTo = VersionSpec.create((int)((int)settings.getChangeBeforeFilter().longValue()));
        }
        if (settings.getDateBeforeFilter() != null) {
            versionTo = VersionSpec.create((Date)settings.getDateBeforeFilter());
        }
        VersionSpec.Range range = new VersionSpec.Range(versionFrom, versionTo);
        logger.info(String.format("Loading committed changes for range %s", range.toString()));
        TFSRepositoryLocation tfsRepositoryLocation = (TFSRepositoryLocation)location;
        ServerContext context = TFSVcs.getInstance(this.project).getServerContext(false);
        List changeSets = CommandUtils.getHistoryCommand((ServerContext)context, (String)tfsRepositoryLocation.getRoot().getPath(), (String)range.toString(), (int)maxCount, (boolean)true, (String)(settings.getUserFilter() == null ? "" : settings.getUserFilter()));
        if (changeSets.isEmpty()) {
            logger.info(String.format("No changesets were found in history for the range %s and user %s", range.toString(), settings.getUserFilter() == null ? "" : settings.getUserFilter()));
            consumer.finished();
            return;
        }
        TFSChangeListBuilder tfsChangeListBuilder = new TFSChangeListBuilder(this.vcs, tfsRepositoryLocation.getWorkspace());
        for (int i = 0; i < changeSets.size() - 1; ++i) {
            consumer.consume((Object)tfsChangeListBuilder.createChangeList((ChangeSet)changeSets.get(i), ((ChangeSet)changeSets.get(i + 1)).getIdAsInt(), ((ChangeSet)changeSets.get(i + 1)).getDate()));
        }
        consumer.consume((Object)tfsChangeListBuilder.createChangeList((ChangeSet)changeSets.get(changeSets.size() - 1), 0, ""));
        consumer.finished();
    }

    public List<TFSChangeList> getCommittedChanges(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount) throws VcsException {
        final ArrayList<TFSChangeList> result = new ArrayList<TFSChangeList>();
        this.loadCommittedChanges(settings, location, maxCount, new AsynchConsumer<CommittedChangeList>(){

            public void finished() {
            }

            public void consume(CommittedChangeList committedChangeList) {
                result.add((TFSChangeList)committedChangeList);
            }
        });
        return result;
    }

    public ChangeListColumn[] getColumns() {
        return new ChangeListColumn[]{new ChangeListColumn.ChangeListNumberColumn(TfPluginBundle.message("Tfvc.RepositoryView.Column.Revision", new Object[0])), ChangeListColumn.NAME, ChangeListColumn.DATE, ChangeListColumn.DESCRIPTION};
    }

    public int getFormatVersion() {
        return 1;
    }

    public void writeChangeList(DataOutput stream, TFSChangeList list) throws IOException {
        list.writeToStream(stream);
    }

    public TFSChangeList readChangeList(RepositoryLocation location, DataInput stream) throws IOException {
        return new TFSChangeList(this.vcs, stream);
    }

    public boolean isMaxCountSupported() {
        return true;
    }

    public Collection<FilePath> getIncomingFiles(RepositoryLocation location) throws VcsException {
        return null;
    }

    public boolean refreshCacheByNumber() {
        return true;
    }

    public String getChangelistTitle() {
        return TfPluginBundle.message("Tfvc.RepositoryView.Changelist.Title", new Object[0]);
    }

    public boolean isChangeLocallyAvailable(FilePath filePath, @Nullable VcsRevisionNumber localRevision, VcsRevisionNumber changeRevision, TFSChangeList changeList) {
        return localRevision != null && localRevision.compareTo((Object)changeRevision) >= 0;
    }

    public boolean refreshIncomingWithCommitted() {
        return false;
    }

    public int getUnlimitedCountValue() {
        return 0;
    }

    @Nullable
    public VcsCommittedViewAuxiliary createActions(DecoratorManager manager, RepositoryLocation location) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/microsoft/alm/plugin/idea/tfvc/core/TFSCommittedChangesProvider", "createDefaultSettings"));
    }
}

